/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.spout;

public class CheckPointState {
    private long txid;
    private State state;

    public CheckPointState(long txid, State state) {
        this.txid = txid;
        this.state = state;
    }

    public CheckPointState() {
    }

    public long getTxid() {
        return this.txid;
    }

    public State getState() {
        return this.state;
    }

    public CheckPointState nextState(boolean recovering) {
        return switch (this.state) {
            case State.PREPARING -> recovering ? new CheckPointState(this.txid - 1L, State.COMMITTED) : new CheckPointState(this.txid, State.COMMITTING);
            case State.COMMITTING -> new CheckPointState(this.txid, State.COMMITTED);
            case State.COMMITTED -> recovering ? this : new CheckPointState(this.txid + 1L, State.PREPARING);
            default -> throw new IllegalStateException("Unknown state " + String.valueOf((Object)this.state));
        };
    }

    public Action nextAction(boolean recovering) {
        return switch (this.state) {
            case State.PREPARING -> recovering ? Action.ROLLBACK : Action.PREPARE;
            case State.COMMITTING -> Action.COMMIT;
            case State.COMMITTED -> recovering ? Action.INITSTATE : Action.PREPARE;
            default -> throw new IllegalStateException("Unknown state " + String.valueOf((Object)this.state));
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckPointState that = (CheckPointState)o;
        if (this.txid != that.txid) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result2 = (int)(this.txid ^ this.txid >>> 32);
        result2 = 31 * result2 + (this.state != null ? this.state.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "CheckPointState{txid=" + this.txid + ", state=" + String.valueOf((Object)this.state) + "}";
    }

    public static enum State {
        COMMITTED,
        COMMITTING,
        PREPARING;

    }

    public static enum Action {
        PREPARE,
        COMMIT,
        ROLLBACK,
        INITSTATE;

    }
}

