/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.cgroup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.storm.container.cgroup.CgroupCommon;
import org.apache.storm.container.cgroup.CgroupOperation;
import org.apache.storm.container.cgroup.CgroupUtils;
import org.apache.storm.container.cgroup.Hierarchy;
import org.apache.storm.container.cgroup.SubSystem;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.SystemOperation;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgroupCenter
implements CgroupOperation {
    private static Logger LOG = LoggerFactory.getLogger(CgroupCenter.class);
    private static CgroupCenter instance;

    private CgroupCenter() {
    }

    public static synchronized CgroupCenter getInstance() {
        if (CgroupUtils.enabled()) {
            instance = new CgroupCenter();
            return instance;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Hierarchy> getHierarchies() {
        HashMap<String, Hierarchy> hierarchies = new HashMap<String, Hierarchy>();
        try (FileReader reader = new FileReader("/proc/mounts");){
            ArrayList<Hierarchy> arrayList;
            try (BufferedReader br = new BufferedReader(reader);){
                String str = null;
                while ((str = br.readLine()) != null) {
                    String[] strSplit = str.split(" ");
                    if (!strSplit[2].equals("cgroup")) continue;
                    String name = strSplit[0];
                    String type = strSplit[3];
                    String dir = strSplit[1];
                    Hierarchy h = new Hierarchy(name, CgroupUtils.getSubSystemsFromString(type), dir);
                    hierarchies.put(type, h);
                }
                arrayList = new ArrayList<Hierarchy>(hierarchies.values());
            }
            return arrayList;
        }
        catch (Exception e) {
            LOG.error("Get hierarchies error {}", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<SubSystem> getSubSystems() {
        HashSet<SubSystem> subSystems = new HashSet<SubSystem>();
        try (FileReader reader = new FileReader("/proc/cgroups");){
            HashSet<SubSystem> hashSet;
            try (BufferedReader br = new BufferedReader(reader);){
                String str = null;
                while ((str = br.readLine()) != null) {
                    String[] split = str.split("\t");
                    SubSystemType type = SubSystemType.getSubSystem(split[0]);
                    if (type == null) continue;
                    int hierarchyId = Integer.valueOf(split[1]);
                    int cgroupNum = Integer.valueOf(split[2]);
                    boolean enable = Integer.valueOf(split[3]) == 1;
                    subSystems.add(new SubSystem(type, hierarchyId, cgroupNum, enable));
                }
                hashSet = subSystems;
            }
            return hashSet;
        }
        catch (Exception e) {
            LOG.error("Get subSystems error {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isSubSystemEnabled(SubSystemType subSystemType) {
        Set<SubSystem> subSystems = this.getSubSystems();
        for (SubSystem subSystem : subSystems) {
            if (subSystem.getType() != subSystemType) continue;
            return true;
        }
        return false;
    }

    @Override
    public Hierarchy getHierarchyWithSubSystem(SubSystemType subSystem) {
        return this.getHierarchyWithSubSystems(Arrays.asList(subSystem));
    }

    @Override
    public Hierarchy getHierarchyWithSubSystems(List<SubSystemType> subSystems) {
        List<Hierarchy> hierarchies = this.getHierarchies();
        Iterator<Hierarchy> iterator = hierarchies.iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy;
            Hierarchy ret = hierarchy = iterator.next();
            for (SubSystemType subSystem : subSystems) {
                if (hierarchy.getSubSystems().contains((Object)subSystem)) continue;
                ret = null;
                break;
            }
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public boolean isMounted(Hierarchy hierarchy) {
        if (Utils.checkDirExists(hierarchy.getDir())) {
            List<Hierarchy> hierarchies = this.getHierarchies();
            for (Hierarchy h : hierarchies) {
                if (!h.equals(hierarchy)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mount(Hierarchy hierarchy) throws IOException {
        if (this.isMounted(hierarchy)) {
            LOG.error("{} is already mounted", (Object)hierarchy.getDir());
            return;
        }
        Set<SubSystemType> subSystems = hierarchy.getSubSystems();
        for (SubSystemType type : subSystems) {
            Hierarchy hierarchyWithSubSystem = this.getHierarchyWithSubSystem(type);
            if (hierarchyWithSubSystem == null) continue;
            LOG.error("subSystem: {} is already mounted on hierarchy: {}", (Object)type.name(), (Object)hierarchyWithSubSystem);
            subSystems.remove((Object)type);
        }
        if (subSystems.size() == 0) {
            return;
        }
        if (!Utils.checkDirExists(hierarchy.getDir())) {
            new File(hierarchy.getDir()).mkdirs();
        }
        String subSystemsName = CgroupUtils.subSystemsToString(subSystems);
        SystemOperation.mount(subSystemsName, hierarchy.getDir(), "cgroup", subSystemsName);
    }

    @Override
    public void umount(Hierarchy hierarchy) throws IOException {
        if (this.isMounted(hierarchy)) {
            hierarchy.getRootCgroups().delete();
            SystemOperation.umount(hierarchy.getDir());
            CgroupUtils.deleteDir(hierarchy.getDir());
        } else {
            LOG.error("{} is not mounted", (Object)hierarchy.getDir());
        }
    }

    @Override
    public void createCgroup(CgroupCommon cgroup) throws SecurityException {
        if (cgroup.isRoot()) {
            LOG.error("You can't create rootCgroup in this function");
            throw new RuntimeException("You can't create rootCgroup in this function");
        }
        for (CgroupCommon parent = cgroup.getParent(); parent != null; parent = parent.getParent()) {
            if (Utils.checkDirExists(parent.getDir())) continue;
            throw new RuntimeException("Parent " + parent.getDir() + "does not exist");
        }
        Hierarchy h = cgroup.getHierarchy();
        if (!this.isMounted(h)) {
            throw new RuntimeException("hierarchy " + h.getDir() + " is not mounted");
        }
        if (Utils.checkDirExists(cgroup.getDir())) {
            throw new RuntimeException("cgroup {} already exists " + cgroup.getDir());
        }
        if (!new File(cgroup.getDir()).mkdir()) {
            throw new RuntimeException("Could not create cgroup dir at " + cgroup.getDir());
        }
    }

    @Override
    public void deleteCgroup(CgroupCommon cgroup) throws IOException {
        cgroup.delete();
    }
}

