/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.royale.swc.catalog;

/**
 * Constants for XML tags and attribute names.
 */
public interface ICatalogXMLConstants
{
    static final String ATTR_BUILD = "build";
    static final String ATTR_CLASS_NAME = "className";
    static final String ATTR_ICON = "icon";
    static final String ATTR_ID = "id";
    static final String ATTR_MINIMUM_SUPPORTED_VERSION = "minimumSupportedVersion";
    static final String ATTR_MOD = "mod";
    static final String ATTR_NAME = "name";
    static final String ATTR_PATH = "path";
    static final String ATTR_PREVIEW = "preview";
    static final String ATTR_SIGNATURE_CHECKSUM = "signatureChecksum";
    static final String ATTR_SIGNED = "signed";
    static final String ATTR_TYPE = "type";
    static final String ATTR_URI = "uri";
    static final String ATTR_VALUE = "value";
    static final String ATTR_VERSION = "version";
    static final String ATTR_XMLNS = "xmlns";
    static final String TAG_COMPILER = "compiler";
    static final String TAG_COMPONENT = "component";
    static final String TAG_COMPONENTS = "components";
    static final String TAG_DEF = "def";
    static final String TAG_DEP = "dep";
    static final String TAG_DIGEST = "digest";
    static final String TAG_DIGESTS = "digests";
    static final String TAG_FEATURE_COMPONENTS = "feature-components";
    static final String TAG_FEATURE_FILES = "feature-files";
    static final String TAG_FEATURE_SCRIPT_DEPS = "feature-script-deps";
    static final String TAG_FEATURES = "features";
    static final String TAG_FILE = "file";
    static final String TAG_FILES = "files";
    static final String TAG_ROYALE = "royale";
    static final String TAG_KEEP_AS3_METADATA = "keep-as3-metadata";
    static final String TAG_LIBRARIES = "libraries";
    static final String TAG_LIBRARY = "library";
    static final String TAG_METADATA = "metadata";
    static final String TAG_SCRIPT = "script";
    static final String TAG_SWC = "swc";
    static final String TAG_VALUE = "value";
    static final String TAG_VERSIONS = "versions";
    static final String XMLNS_SWC_CATALOG_9 = "http://www.adobe.com/flash/swccatalog/9";
}
