/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EnumType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private EnumElementType elementsType;
    private final Set<String> elements = new HashSet<String>();

    EnumType(JSTypeRegistry registry, String name, Node source, JSType elementsType) {
        super(registry, "enum{" + name + "}", null);
        this.elementsType = new EnumElementType(registry, elementsType, name, this);
    }

    @Override
    public EnumType toMaybeEnumType() {
        return this;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
    }

    public Set<String> getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public boolean defineElement(String name, Node definingNode) {
        this.elements.add(name);
        return this.defineDeclaredProperty(name, this.elementsType, definingNode);
    }

    public EnumElementType getElementsType() {
        return this.elementsType;
    }

    @Override
    public JSType getEnumeratedTypeOfEnumObject() {
        return this.elementsType.getPrimitiveType();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        return this.isEquivalentTo(that) ? TernaryValue.TRUE : TernaryValue.FALSE;
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create(), JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        return that.isEquivalentTo(this.getNativeType(JSTypeNative.OBJECT_TYPE)) || that.isEquivalentTo(this.getNativeType(JSTypeNative.OBJECT_PROTOTYPE)) || JSType.isSubtypeHelper(this, that, implicitImplCache, subtypingMode);
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        return sb.append(forAnnotations ? "!Object" : this.getReferenceName());
    }

    @Override
    public String getDisplayName() {
        return this.elementsType.getDisplayName();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseObjectType(this, that);
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public boolean matchesNumberContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        this.elementsType = (EnumElementType)this.elementsType.resolve(reporter);
        return super.resolveInternal(reporter);
    }
}

