/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public class J2clEqualitySameRewriterPass
extends AbstractPeepholeOptimization {
    private boolean shouldRunJ2clPasses = false;

    @Override
    void beginTraversal(AbstractCompiler compiler) {
        super.beginTraversal(compiler);
        this.shouldRunJ2clPasses = J2clSourceFileChecker.shouldRunJ2clPasses(compiler);
    }

    @Override
    Node optimizeSubtree(Node node) {
        if (!this.shouldRunJ2clPasses) {
            return node;
        }
        if (!J2clEqualitySameRewriterPass.isEqualitySameCall(node)) {
            return node;
        }
        Node replacement = this.trySubstituteEqualitySame(node);
        if (replacement != node) {
            replacement = replacement.useSourceInfoIfMissingFrom(node);
            node.replaceWith(replacement);
            this.compiler.reportChangeToEnclosingScope(replacement);
        }
        return replacement;
    }

    private Node trySubstituteEqualitySame(Node callNode) {
        Node firstExpr = callNode.getSecondChild();
        Node secondExpr = callNode.getLastChild();
        if (NodeUtil.isNullOrUndefined(firstExpr) || NodeUtil.isNullOrUndefined(secondExpr)) {
            return this.rewriteToEq(firstExpr, secondExpr, Eq.DOUBLE);
        }
        if (NodeUtil.isLiteralValue(firstExpr, true) || NodeUtil.isLiteralValue(secondExpr, true)) {
            return this.rewriteToEq(firstExpr, secondExpr, Eq.TRIPLE);
        }
        return callNode;
    }

    private Node rewriteToEq(Node firstExpr, Node secondExpr, Eq eq) {
        firstExpr.detach();
        secondExpr.detach();
        return eq == Eq.DOUBLE ? IR.eq(firstExpr, secondExpr) : IR.sheq(firstExpr, secondExpr);
    }

    private static boolean isEqualitySameCall(Node node) {
        return node.isCall() && node.hasXChildren(3) && J2clEqualitySameRewriterPass.isEqualitySameMethodName(node.getFirstChild());
    }

    private static boolean isEqualitySameMethodName(Node fnName) {
        if (!fnName.isQualifiedName()) {
            return false;
        }
        String originalQname = fnName.getOriginalQualifiedName();
        return originalQname.endsWith(".$same") && originalQname.contains("Equality");
    }

    private static enum Eq {
        DOUBLE,
        TRIPLE;

    }
}

