/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

class InferConsts
implements CompilerPass {
    private final AbstractCompiler compiler;

    InferConsts(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node js) {
        ReferenceCollectingCallback collector = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, new Es6SyntacticScopeCreator(this.compiler));
        collector.process(js);
        for (Var v : collector.getAllSymbols()) {
            this.considerVar(v, collector.getReferences(v));
        }
        AbstractScope globalExternsScope = new Es6SyntacticScopeCreator(this.compiler).createScope(externs, (AbstractScope)null);
        for (Var v : ((Scope)globalExternsScope).getAllSymbols()) {
            this.considerVar(v, null);
        }
    }

    private void considerVar(Var v, ReferenceCollection refCollection) {
        Node nameNode = v.getNameNode();
        JSDocInfo docInfo = v.getJSDocInfo();
        if (docInfo != null && docInfo.isConstant()) {
            nameNode.putBooleanProp(Node.IS_CONSTANT_VAR, true);
        } else if (nameNode != null && nameNode.getParent().isConst()) {
            nameNode.putBooleanProp(Node.IS_CONSTANT_VAR, true);
        } else if (nameNode != null && this.compiler.getCodingConvention().isConstant(nameNode.getString())) {
            nameNode.putBooleanProp(Node.IS_CONSTANT_VAR, true);
        } else if (nameNode != null && refCollection != null && refCollection.isWellDefined() && refCollection.isAssignedOnceInLifetime() && refCollection.firstReferenceIsAssigningDeclaration()) {
            nameNode.putBooleanProp(Node.IS_CONSTANT_VAR, true);
        }
    }
}

