/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CollapseVariableDeclarations
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final List<Collapse> collapses = new ArrayList<Collapse>();
    private final Set<Node> nodesToCollapse = new HashSet<Node>();

    CollapseVariableDeclarations(AbstractCompiler compiler) {
        Preconditions.checkState(!compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.collapses.clear();
        this.nodesToCollapse.clear();
        NodeTraversal.traverse(this.compiler, root, new GatherCollapses());
        if (!this.collapses.isEmpty()) {
            this.applyCollapses();
        }
    }

    private void applyCollapses() {
        for (Collapse collapse : this.collapses) {
            Node var = collapse.startNode;
            this.compiler.reportChangeToEnclosingScope(var);
            while (var.getNext() != null && var.getNext().getToken() == var.getToken()) {
                Node next = collapse.parent.removeChildAfter(var);
                var.addChildrenToBack(next.removeChildren());
            }
        }
    }

    private class GatherCollapses
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherCollapses() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (CollapseVariableDeclarations.this.nodesToCollapse.contains(n)) {
                return;
            }
            if (!NodeUtil.isNameDeclaration(n)) {
                return;
            }
            if (parent.isIf()) {
                return;
            }
            Node varNode = n;
            Token nType = n.getToken();
            boolean hasNodesToCollapse = false;
            for (n = n.getNext(); n != null && nType == n.getToken(); n = n.getNext()) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(n);
                hasNodesToCollapse = true;
            }
            if (hasNodesToCollapse) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(varNode);
                CollapseVariableDeclarations.this.collapses.add(new Collapse(varNode, n, parent));
            }
        }
    }

    private static class Collapse {
        final Node startNode;
        final Node parent;

        Collapse(Node startNode, Node endNode, Node parent) {
            this.startNode = startNode;
            this.parent = parent;
        }
    }
}

