/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FixedChildrenNode;
import org.apache.royale.compiler.internal.tree.as.FullNameNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.QualifiedNamespaceExpressionNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.IUseNamespaceNode;

public class UseNamespaceNode
extends FixedChildrenNode
implements IUseNamespaceNode {
    protected INamespaceDecorationNode namespaceNode;

    public UseNamespaceNode(ExpressionNodeBase namespace) {
        this.setTargetNamespace(namespace);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.UseID;
    }

    @Override
    public int getChildCount() {
        return this.namespaceNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        if (i == 0) {
            return this.namespaceNode;
        }
        return null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.namespaceNode != null) {
            ((NodeBase)((Object)this.namespaceNode)).normalize(fillInOffsets);
            ((NodeBase)((Object)this.namespaceNode)).setParent(this);
        }
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            NamespaceDefinition.addUseNamespaceDirectiveToScope(scope, this.getTargetNamespaceNode());
        }
    }

    @Override
    public INamespaceDecorationNode getTargetNamespaceNode() {
        return this.namespaceNode;
    }

    @Override
    public String getTargetNamespace() {
        return this.namespaceNode != null ? this.namespaceNode.getName() : "";
    }

    public void setTargetNamespace(ExpressionNodeBase namespace) {
        if (namespace != null) {
            if (namespace instanceof FullNameNode) {
                this.namespaceNode = new QualifiedNamespaceExpressionNode((MemberAccessExpressionNode)((FullNameNode)namespace));
            } else {
                this.namespaceNode = new NamespaceIdentifierNode(((IIdentifierNode)((Object)namespace)).getName());
                ((NodeBase)((Object)this.namespaceNode)).setSourcePath(namespace.getSourcePath());
                ((NodeBase)((Object)this.namespaceNode)).span(namespace.getAbsoluteStart(), namespace.getAbsoluteEnd(), namespace.getLine(), namespace.getColumn(), namespace.getEndLine(), namespace.getEndColumn());
            }
        }
    }
}

