/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import org.apache.royale.compiler.definitions.IGetterDefinition;
import org.apache.royale.compiler.definitions.ISetterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.SetterDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.problems.IncompatibleOverrideProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IGetterNode;

public class GetterDefinition
extends AccessorDefinition
implements IGetterDefinition {
    public GetterDefinition(String name) {
        super(name);
    }

    @Override
    public ISetterDefinition resolveSetter(ICompilerProject project) {
        return (ISetterDefinition)((Object)this.resolveCorrespondingAccessor(project));
    }

    @Override
    public boolean isSkinPart() {
        return this.getSkinPart() != null;
    }

    @Override
    public boolean isRequiredSkinPart() {
        IMetaTag skinPart = this.getSkinPart();
        if (skinPart == null) {
            return false;
        }
        return this.isRequiredSkinPart(skinPart);
    }

    @Override
    public void buildInnerString(StringBuilder sb) {
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        sb.append("function");
        sb.append(' ');
        if (this.isStatic()) {
            sb.append("static");
            sb.append(' ');
        }
        sb.append("get");
        sb.append(' ');
        sb.append(this.getBaseName());
        sb.append('(');
        sb.append(')');
        String type = this.getTypeAsDisplayString();
        if (!type.isEmpty()) {
            sb.append(':');
            sb.append(type);
        }
    }

    @Override
    public FunctionDefinition resolveOverriddenFunction(ICompilerProject project) {
        FunctionDefinition override = super.resolveOverriddenFunction(project);
        if (override instanceof SetterDefinition) {
            override = ((SetterDefinition)override).resolveCorrespondingAccessor(project);
        }
        if (override != null && this.getNamespaceReference().isLanguageNamespace()) {
            boolean valid;
            boolean bl = valid = this.isProtected() && override.isProtected() || this.isPublic() && override.isPublic() || this.isInternal() && override.isInternal();
            if (!(valid || override.getNamespaceReference() == this.getNamespaceReference() || !this.isPrivate() && project.getAllowPrivateNameConflicts() && override.isPrivate())) {
                project.getProblems().add(new IncompatibleOverrideProblem(this.getNode()));
            }
        }
        return override;
    }

    @Override
    public TypeDefinitionBase resolveType(ICompilerProject project) {
        IGetterNode getterNode;
        ITypeDefinition typeDef;
        if (project.getInferTypes() && this.getTypeReference() == null && (typeDef = SemanticUtils.resolveFunctionInferredReturnType(getterNode = (IGetterNode)this.getNode(), project)) != null) {
            this.setTypeReference(ReferenceFactory.resolvedReference(typeDef));
            return (TypeDefinitionBase)typeDef;
        }
        return super.resolveType(project);
    }

    @Override
    public ITypeDefinition resolveReturnType(ICompilerProject project) {
        return this.resolveType(project);
    }
}

