/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.databinding;

import java.util.LinkedList;
import java.util.List;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IConstantDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.as.codegen.InstructionListNode;
import org.apache.royale.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import org.apache.royale.compiler.internal.codegen.databinding.BindingDestinationMaker;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLArrayNode;
import org.apache.royale.compiler.tree.mxml.IMXMLBindingAttributeNode;
import org.apache.royale.compiler.tree.mxml.IMXMLBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassReferenceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLConcatenatedDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLExpressionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelPropertyNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLSingleDataBindingNode;

public class BindingInfo
implements Comparable<BindingInfo> {
    private final List<IExpressionNode> expressionNodesForGetter;
    private String destinationString;
    final int index;
    private boolean isSimplePublicProperty;
    private String sourceString;
    private int twoWayCounterpart = -1;
    public IMXMLNode node;
    public ClassDefinition classDef;
    private IExpressionNode expressionNodeForSetter;

    public BindingInfo(IMXMLDataBindingNode dbnode, int index, MXMLClassDirectiveProcessor host) {
        this.index = index;
        this.node = dbnode;
        this.expressionNodesForGetter = new LinkedList<IExpressionNode>();
        if (dbnode instanceof IMXMLSingleDataBindingNode) {
            this.expressionNodesForGetter.add(((IMXMLSingleDataBindingNode)dbnode).getExpressionNode());
        } else if (dbnode instanceof IMXMLConcatenatedDataBindingNode) {
            for (int childIndex = 0; childIndex < dbnode.getChildCount(); ++childIndex) {
                IASNode child = dbnode.getChild(childIndex);
                if (child instanceof IMXMLSingleDataBindingNode) {
                    this.expressionNodesForGetter.add(((IMXMLSingleDataBindingNode)child).getExpressionNode());
                    continue;
                }
                if (child instanceof IExpressionNode) {
                    this.expressionNodesForGetter.add((IExpressionNode)child);
                    continue;
                }
                assert (false);
            }
        } else assert (false);
        this.expressionNodeForSetter = BindingDestinationMaker.makeDestinationFunctionInstructionList(dbnode, host);
        this.destinationString = BindingInfo.findDestinationString(dbnode, host);
        this.finishInit(host);
    }

    public BindingInfo(IMXMLBindingNode bindingNode, int index, MXMLClassDirectiveProcessor host, boolean reverseSourceAndDest) {
        this.index = index;
        this.node = bindingNode;
        IExpressionNode destinationNode = null;
        this.expressionNodesForGetter = new LinkedList<IExpressionNode>();
        if (!reverseSourceAndDest) {
            this.expressionNodesForGetter.add(bindingNode.getSourceAttributeNode().getExpressionNode());
            destinationNode = bindingNode.getDestinationAttributeNode().getExpressionNode();
        } else {
            this.expressionNodesForGetter.add(bindingNode.getDestinationAttributeNode().getExpressionNode());
            destinationNode = bindingNode.getSourceAttributeNode().getExpressionNode();
        }
        this.expressionNodeForSetter = destinationNode;
        this.destinationString = BindingInfo.findDestinationString(destinationNode, host);
        assert (this.expressionNodeForSetter != null);
        this.finishInit(host);
    }

    private void finishInit(MXMLClassDirectiveProcessor host) {
        ClassDefinition classDef = host.getClassDefinition();
        ASScope classScope = classDef.getContainedScope();
        this.analyzeExpression(host.getProject(), classScope);
    }

    public int getIndex() {
        assert (this.index >= 0);
        return this.index;
    }

    public int getTwoWayCounterpart() {
        return this.twoWayCounterpart;
    }

    public void setTwoWayCounterpart(int twoWayCounterparterpart) {
        this.twoWayCounterpart = twoWayCounterparterpart;
    }

    public List<IExpressionNode> getExpressionNodesForGetter() {
        return this.expressionNodesForGetter;
    }

    public IExpressionNode getExpressionNodeForDestination() {
        return this.expressionNodeForSetter;
    }

    public String getDestinationString() {
        return this.destinationString;
    }

    public void setDestinationString(String newDestString) {
        this.destinationString = newDestString;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BindingInfo #" + this.index + " destStr:" + this.destinationString + " srcStr:" + this.sourceString + "\n");
        if (this.expressionNodeForSetter != null) {
            sb.append("    destFunc ");
            sb.append("node:\n");
            NodeBase n = (NodeBase)((Object)this.expressionNodeForSetter);
            n.buildStringRecursive(sb, 3, false);
        }
        if (!this.expressionNodesForGetter.isEmpty()) {
            sb.append("    Getter Expressions:\n");
            for (IExpressionNode e : this.expressionNodesForGetter) {
                NodeBase n = (NodeBase)((Object)e);
                n.buildStringRecursive(sb, 3, false);
            }
        }
        return sb.toString();
    }

    private static String findDestinationString(IASNode node, MXMLClassDirectiveProcessor host) {
        Object destString = null;
        IASNode parent = node.getParent();
        if (parent instanceof IMXMLPropertySpecifierNode) {
            destString = BindingInfo.findDestinationStringFromPropertySpecifier((IMXMLPropertySpecifierNode)parent);
        } else if (parent instanceof IMXMLBindingAttributeNode) {
            destString = BindingInfo.findDestinationStringFromBindingAttribute(node);
        } else if (parent instanceof IMXMLExpressionNode) {
            String id = ((IMXMLExpressionNode)parent).getEffectiveID();
            assert (id != null);
            IMXMLClassReferenceNode propertyParent = (IMXMLClassReferenceNode)parent.getAncestorOfType(IMXMLClassReferenceNode.class);
            assert (propertyParent != null);
            destString = propertyParent instanceof IMXMLClassDefinitionNode ? "this." + id : id;
        } else if (parent instanceof IMXMLArrayNode) {
            String id = ((IMXMLArrayNode)parent).getEffectiveID();
            assert (id != null);
            IMXMLClassReferenceNode propertyParent = (IMXMLClassReferenceNode)parent.getAncestorOfType(IMXMLClassReferenceNode.class);
            assert (propertyParent != null);
            destString = propertyParent instanceof IMXMLClassDefinitionNode ? "this." + id : id;
        } else if (!(parent instanceof IMXMLModelPropertyNode)) {
            System.err.println("findDestinationString can't parse parent: " + parent);
        }
        return destString;
    }

    private static String findDestinationStringFromBindingAttribute(IASNode node) {
        Object ret = null;
        if (node instanceof IMemberAccessExpressionNode) {
            IMemberAccessExpressionNode maNode = (IMemberAccessExpressionNode)node;
            IExpressionNode left = maNode.getLeftOperandNode();
            IExpressionNode right = maNode.getRightOperandNode();
            if (left instanceof IIdentifierNode && right instanceof IIdentifierNode) {
                ret = ((IIdentifierNode)left).getName() + "." + ((IIdentifierNode)right).getName();
            }
        } else if (node instanceof IIdentifierNode) {
            ret = ((IIdentifierNode)node).getName();
        } else if (!(node instanceof InstructionListNode)) {
            // empty if block
        }
        return ret;
    }

    private static String findDestinationStringFromPropertySpecifier(IMXMLPropertySpecifierNode propertySpecifier) {
        String ret = null;
        IMXMLClassReferenceNode propertyParent = (IMXMLClassReferenceNode)propertySpecifier.getAncestorOfType(IMXMLClassReferenceNode.class);
        assert (propertyParent != null);
        if (propertyParent instanceof IMXMLInstanceNode) {
            IMXMLInstanceNode instanceNode = (IMXMLInstanceNode)propertyParent;
            String id = instanceNode.getEffectiveID();
            assert (id != null);
            assert (instanceNode.getID() == null || id.equals(instanceNode.getID()));
            ret = id + "." + propertySpecifier.getName();
        } else if (propertyParent instanceof IMXMLClassDefinitionNode) {
            ret = "this." + propertySpecifier.getName();
        } else assert (false);
        return ret;
    }

    @Override
    public int compareTo(BindingInfo o) {
        return this.index - o.index;
    }

    public boolean isSourceSimplePublicProperty() {
        return this.isSimplePublicProperty;
    }

    public String getSourceString() {
        return this.sourceString;
    }

    private void analyzeExpression(ICompilerProject project, ASScope scope) {
        assert (scope instanceof TypeScope);
        if (this.expressionNodesForGetter.size() != 1) {
            return;
        }
        IExpressionNode expressionNodeForGetter = this.expressionNodesForGetter.get(0);
        boolean hadThis = false;
        if (expressionNodeForGetter instanceof MemberAccessExpressionNode && ((MemberAccessExpressionNode)expressionNodeForGetter).getLeftOperandNode() instanceof IIdentifierNode && ((IIdentifierNode)((MemberAccessExpressionNode)expressionNodeForGetter).getLeftOperandNode()).getName().equals("this")) {
            expressionNodeForGetter = ((MemberAccessExpressionNode)expressionNodeForGetter).getRightOperandNode();
            hadThis = true;
        }
        if (expressionNodeForGetter instanceof IIdentifierNode) {
            IConstantDefinition cnst;
            IVariableDefinition var;
            INamespaceReference ns;
            ASScope resolutionScope;
            String name = ((IIdentifierNode)expressionNodeForGetter).getName();
            IReference ref = ReferenceFactory.lexicalReference(project.getWorkspace(), name);
            IDefinition def = ref.resolve(project, resolutionScope = hadThis ? ((TypeScope)scope).getInstanceScope() : scope, DependencyType.EXPRESSION, false);
            if (def instanceof IVariableDefinition && (ns = (var = (IVariableDefinition)def).getNamespaceReference()) == NamespaceDefinition.getPublicNamespaceDefinition()) {
                this.sourceString = def.getBaseName();
                this.isSimplePublicProperty = true;
            }
            if (def instanceof IConstantDefinition && (ns = (cnst = (IConstantDefinition)def).getNamespaceReference()) == NamespaceDefinition.getPublicNamespaceDefinition()) {
                this.sourceString = def.getBaseName();
                this.isSimplePublicProperty = true;
            }
        } else if (expressionNodeForGetter instanceof MemberAccessExpressionNode) {
            MemberAccessExpressionNode mae = (MemberAccessExpressionNode)expressionNodeForGetter;
            IDefinition def = hadThis ? this.expressionNodesForGetter.get(0).resolve(project) : mae.resolve(project);
            if (def != null && def.isPublic() && (def instanceof IAccessorDefinition || def instanceof IConstantDefinition || def instanceof IVariableDefinition)) {
                IDefinition argDef;
                IExpressionNode arg;
                IFunctionCallNode fun;
                IExpressionNode[] args;
                IExpressionNode leftSide = mae.getLeftOperandNode();
                if (leftSide instanceof IIdentifierNode) {
                    IDefinition leftDef = leftSide.resolve(project);
                    if (leftDef.isPublic()) {
                        if (leftDef instanceof ClassDefinition) {
                            this.classDef = (ClassDefinition)leftDef;
                        }
                        this.sourceString = leftDef.getBaseName() + "." + def.getBaseName();
                        this.isSimplePublicProperty = true;
                    }
                } else if (leftSide instanceof MemberAccessExpressionNode) {
                    IDefinition leftDef = leftSide.resolve(project);
                    if (leftDef.isPublic()) {
                        if (leftDef instanceof ClassDefinition) {
                            this.classDef = (ClassDefinition)leftDef;
                            this.sourceString = leftDef.getBaseName() + "." + def.getBaseName();
                            this.isSimplePublicProperty = true;
                        } else {
                            this.sourceString = this.buildChain((MemberAccessExpressionNode)leftSide);
                            if (this.sourceString != null) {
                                this.sourceString = this.sourceString + "." + def.getBaseName();
                                this.isSimplePublicProperty = true;
                            }
                        }
                    }
                } else if (leftSide instanceof IFunctionCallNode && (args = (fun = (IFunctionCallNode)leftSide).getArgumentNodes()).length == 1 && (arg = args[0]) instanceof IIdentifierNode && (argDef = arg.resolve(project)).isPublic()) {
                    this.sourceString = argDef.getBaseName() + "." + def.getBaseName();
                    this.isSimplePublicProperty = true;
                }
            }
        }
    }

    private String buildChain(MemberAccessExpressionNode mae) {
        IExpressionNode right;
        IExpressionNode left = mae.getLeftOperandNode();
        if (left.getNodeID() == ASTNodeID.IdentifierID) {
            IExpressionNode right2 = mae.getRightOperandNode();
            if (right2.getNodeID() == ASTNodeID.IdentifierID) {
                return ((IdentifierNode)left).getName() + "." + ((IdentifierNode)right2).getName();
            }
        } else if (left.getNodeID() == ASTNodeID.MemberAccessExpressionID && (right = mae.getRightOperandNode()).getNodeID() == ASTNodeID.IdentifierID) {
            String l = this.buildChain((MemberAccessExpressionNode)left);
            if (l == null) {
                return null;
            }
            return l + "." + ((IdentifierNode)right).getName();
        }
        return null;
    }
}

