/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.io.VirtualFile;
import java.io.File;

public final class Source
implements Comparable<Source> {
    private VirtualFile file;
    private VirtualFile pathRoot;
    private String relativePath;
    private String shortName;
    private Object owner;
    private boolean isInternal;
    private boolean isRoot;
    private boolean isDebuggable;

    public Source(VirtualFile file, Source original) {
        this(file, original.pathRoot, original.relativePath, original.shortName, original.owner, original.isInternal, original.isRoot, original.isDebuggable);
    }

    public Source(VirtualFile file, Source original, String shortName, boolean isInternal, boolean isRoot) {
        this(file, original.pathRoot, original.relativePath, shortName, null, isInternal, isRoot, true);
    }

    public Source(VirtualFile file, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot) {
        this(file, null, relativePath, shortName, owner, isInternal, isRoot, true);
    }

    public Source(VirtualFile file, VirtualFile pathRoot, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot) {
        this(file, pathRoot, relativePath, shortName, owner, isInternal, isRoot, true);
    }

    public Source(VirtualFile file, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot, boolean isDebuggable) {
        this(file, null, relativePath, shortName, owner, isInternal, isRoot, isDebuggable);
    }

    Source(VirtualFile file, VirtualFile pathRoot, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot, boolean isDebuggable) {
        this.file = file;
        this.pathRoot = pathRoot;
        this.relativePath = relativePath;
        this.shortName = shortName;
        this.owner = owner;
        this.isInternal = isInternal;
        this.isRoot = isRoot;
        this.isDebuggable = isDebuggable;
        if (file != null) {
            // empty if block
        }
    }

    @Override
    public int compareTo(Source source) {
        return this.getName().compareTo(source.getName());
    }

    public String getName() {
        return this.file.getName();
    }

    public String getNameForReporting() {
        return this.file.getNameForReporting();
    }

    public String getSourceFileName() {
        Object s = this.getName();
        if (this.relativePath.length() > 0) {
            s = (String)s + this.relativePath;
        }
        s = (String)s + File.separator;
        s = (String)s + this.shortName;
        return s;
    }

    public boolean exists() {
        return this.file.getLastModified() > 0L;
    }
}

