/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.JSHandle;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.FrameExpectOptions;
import com.microsoft.playwright.impl.FrameExpectResult;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.FrameLocatorImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.BoundingBox;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.SelectOption;
import com.microsoft.playwright.options.WaitForSelectorState;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Pattern;

class LocatorImpl
implements Locator {
    private final FrameImpl frame;
    private final String selector;
    private static final Filters filters = new Filters();

    public LocatorImpl(FrameImpl frame, String selector, Locator.LocatorOptions options) {
        this.frame = frame;
        if (options != null) {
            if (options.hasText != null) {
                if (options.hasText instanceof Pattern) {
                    Pattern pattern = (Pattern)options.hasText;
                    selector = selector + " >> :scope:text-matches(" + LocatorImpl.escapeWithQuotes(pattern.pattern()) + ", \"" + Utils.toJsRegexFlags(pattern) + "\")";
                } else if (options.hasText instanceof String) {
                    String text = (String)options.hasText;
                    selector = selector + " >> :scope:has-text(" + LocatorImpl.escapeWithQuotes(text) + ")";
                }
            }
            selector = filters.addFiltersToSelector(selector, options, frame);
        }
        this.selector = selector;
    }

    private static String escapeWithQuotes(String text) {
        return Serialization.gson().toJson((Object)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, O> R withElement(BiFunction<ElementHandle, O, R> callback, O options) {
        Locator.ElementHandleOptions handleOptions = Utils.convertType(options, Locator.ElementHandleOptions.class);
        ElementHandle handle = this.elementHandle(handleOptions);
        try {
            R r = callback.apply(handle, options);
            return r;
        }
        finally {
            if (handle != null) {
                handle.dispose();
            }
        }
    }

    @Override
    public List<String> allInnerTexts() {
        return (List)this.frame.evalOnSelectorAll(this.selector, "ee => ee.map(e => e.innerText)");
    }

    @Override
    public List<String> allTextContents() {
        return (List)this.frame.evalOnSelectorAll(this.selector, "ee => ee.map(e => e.textContent || '')");
    }

    @Override
    public BoundingBox boundingBox(Locator.BoundingBoxOptions options) {
        return this.withElement((h, o) -> h.boundingBox(), options);
    }

    @Override
    public void check(Locator.CheckOptions options) {
        if (options == null) {
            options = new Locator.CheckOptions();
        }
        this.frame.check(this.selector, Utils.convertType(options, Frame.CheckOptions.class).setStrict(true));
    }

    @Override
    public void click(Locator.ClickOptions options) {
        if (options == null) {
            options = new Locator.ClickOptions();
        }
        this.frame.click(this.selector, Utils.convertType(options, Frame.ClickOptions.class).setStrict(true));
    }

    @Override
    public int count() {
        return this.frame.queryCount(this.selector);
    }

    @Override
    public void dblclick(Locator.DblclickOptions options) {
        if (options == null) {
            options = new Locator.DblclickOptions();
        }
        this.frame.dblclick(this.selector, Utils.convertType(options, Frame.DblclickOptions.class).setStrict(true));
    }

    @Override
    public void dispatchEvent(String type, Object eventInit, Locator.DispatchEventOptions options) {
        if (options == null) {
            options = new Locator.DispatchEventOptions();
        }
        this.frame.dispatchEvent(this.selector, type, eventInit, Utils.convertType(options, Frame.DispatchEventOptions.class).setStrict(true));
    }

    @Override
    public void dragTo(Locator target, Locator.DragToOptions options) {
        if (options == null) {
            options = new Locator.DragToOptions();
        }
        Frame.DragAndDropOptions frameOptions = Utils.convertType(options, Frame.DragAndDropOptions.class);
        frameOptions.setStrict(true);
        this.frame.dragAndDrop(this.selector, ((LocatorImpl)target).selector, frameOptions);
    }

    @Override
    public ElementHandle elementHandle(Locator.ElementHandleOptions options) {
        if (options == null) {
            options = new Locator.ElementHandleOptions();
        }
        Frame.WaitForSelectorOptions frameOptions = Utils.convertType(options, Frame.WaitForSelectorOptions.class);
        frameOptions.setStrict(true);
        frameOptions.setState(WaitForSelectorState.ATTACHED);
        return this.frame.waitForSelector(this.selector, frameOptions);
    }

    @Override
    public List<ElementHandle> elementHandles() {
        return this.frame.querySelectorAll(this.selector);
    }

    @Override
    public Object evaluate(String expression, Object arg, Locator.EvaluateOptions options) {
        return this.withElement((h, o) -> h.evaluate(expression, arg), options);
    }

    @Override
    public Object evaluateAll(String expression, Object arg) {
        return this.frame.evalOnSelectorAll(this.selector, expression, arg);
    }

    @Override
    public JSHandle evaluateHandle(String expression, Object arg, Locator.EvaluateHandleOptions options) {
        return this.withElement((h, o) -> h.evaluateHandle(expression, arg), options);
    }

    @Override
    public void fill(String value, Locator.FillOptions options) {
        if (options == null) {
            options = new Locator.FillOptions();
        }
        this.frame.fill(this.selector, value, Utils.convertType(options, Frame.FillOptions.class).setStrict(true));
    }

    @Override
    public Locator filter(Locator.FilterOptions options) {
        return new LocatorImpl(this.frame, this.selector, Utils.convertType(options, Locator.LocatorOptions.class));
    }

    @Override
    public Locator first() {
        return new LocatorImpl(this.frame, this.selector + " >> nth=0", null);
    }

    @Override
    public void focus(Locator.FocusOptions options) {
        if (options == null) {
            options = new Locator.FocusOptions();
        }
        this.frame.focus(this.selector, Utils.convertType(options, Frame.FocusOptions.class).setStrict(true));
    }

    @Override
    public FrameLocatorImpl frameLocator(String selector) {
        return new FrameLocatorImpl(this.frame, this.selector + " >> " + selector);
    }

    @Override
    public String getAttribute(String name, Locator.GetAttributeOptions options) {
        if (options == null) {
            options = new Locator.GetAttributeOptions();
        }
        return this.frame.getAttribute(this.selector, name, Utils.convertType(options, Frame.GetAttributeOptions.class).setStrict(true));
    }

    @Override
    public void highlight() {
        this.frame.highlightImpl(this.selector);
    }

    @Override
    public void hover(Locator.HoverOptions options) {
        if (options == null) {
            options = new Locator.HoverOptions();
        }
        this.frame.hover(this.selector, Utils.convertType(options, Frame.HoverOptions.class).setStrict(true));
    }

    @Override
    public String innerHTML(Locator.InnerHTMLOptions options) {
        if (options == null) {
            options = new Locator.InnerHTMLOptions();
        }
        return this.frame.innerHTML(this.selector, Utils.convertType(options, Frame.InnerHTMLOptions.class).setStrict(true));
    }

    @Override
    public String innerText(Locator.InnerTextOptions options) {
        if (options == null) {
            options = new Locator.InnerTextOptions();
        }
        return this.frame.innerText(this.selector, Utils.convertType(options, Frame.InnerTextOptions.class).setStrict(true));
    }

    @Override
    public String inputValue(Locator.InputValueOptions options) {
        if (options == null) {
            options = new Locator.InputValueOptions();
        }
        return this.frame.inputValue(this.selector, Utils.convertType(options, Frame.InputValueOptions.class).setStrict(true));
    }

    @Override
    public boolean isChecked(Locator.IsCheckedOptions options) {
        if (options == null) {
            options = new Locator.IsCheckedOptions();
        }
        return this.frame.isChecked(this.selector, Utils.convertType(options, Frame.IsCheckedOptions.class).setStrict(true));
    }

    @Override
    public boolean isDisabled(Locator.IsDisabledOptions options) {
        if (options == null) {
            options = new Locator.IsDisabledOptions();
        }
        return this.frame.isDisabled(this.selector, Utils.convertType(options, Frame.IsDisabledOptions.class).setStrict(true));
    }

    @Override
    public boolean isEditable(Locator.IsEditableOptions options) {
        if (options == null) {
            options = new Locator.IsEditableOptions();
        }
        return this.frame.isEditable(this.selector, Utils.convertType(options, Frame.IsEditableOptions.class).setStrict(true));
    }

    @Override
    public boolean isEnabled(Locator.IsEnabledOptions options) {
        if (options == null) {
            options = new Locator.IsEnabledOptions();
        }
        return this.frame.isEnabled(this.selector, Utils.convertType(options, Frame.IsEnabledOptions.class).setStrict(true));
    }

    @Override
    public boolean isHidden(Locator.IsHiddenOptions options) {
        if (options == null) {
            options = new Locator.IsHiddenOptions();
        }
        return this.frame.isHidden(this.selector, Utils.convertType(options, Frame.IsHiddenOptions.class).setStrict(true));
    }

    @Override
    public boolean isVisible(Locator.IsVisibleOptions options) {
        if (options == null) {
            options = new Locator.IsVisibleOptions();
        }
        return this.frame.isVisible(this.selector, Utils.convertType(options, Frame.IsVisibleOptions.class).setStrict(true));
    }

    @Override
    public Locator last() {
        return new LocatorImpl(this.frame, this.selector + " >> nth=-1", null);
    }

    @Override
    public Locator locator(String selector, Locator.LocatorOptions options) {
        return new LocatorImpl(this.frame, this.selector + " >> " + selector, options);
    }

    @Override
    public Locator nth(int index) {
        return new LocatorImpl(this.frame, this.selector + " >> nth=" + index, null);
    }

    @Override
    public Page page() {
        return this.frame.page();
    }

    @Override
    public void press(String key, Locator.PressOptions options) {
        if (options == null) {
            options = new Locator.PressOptions();
        }
        this.frame.press(this.selector, key, Utils.convertType(options, Frame.PressOptions.class).setStrict(true));
    }

    @Override
    public byte[] screenshot(Locator.ScreenshotOptions options) {
        return this.withElement((h, o) -> h.screenshot((ElementHandle.ScreenshotOptions)o), Utils.convertType(options, ElementHandle.ScreenshotOptions.class));
    }

    @Override
    public void scrollIntoViewIfNeeded(Locator.ScrollIntoViewIfNeededOptions options) {
        this.withElement((h, o) -> {
            h.scrollIntoViewIfNeeded((ElementHandle.ScrollIntoViewIfNeededOptions)o);
            return null;
        }, Utils.convertType(options, ElementHandle.ScrollIntoViewIfNeededOptions.class));
    }

    @Override
    public List<String> selectOption(String values, Locator.SelectOptionOptions options) {
        if (options == null) {
            options = new Locator.SelectOptionOptions();
        }
        return this.frame.selectOption(this.selector, values, Utils.convertType(options, Frame.SelectOptionOptions.class).setStrict(true));
    }

    @Override
    public List<String> selectOption(ElementHandle values, Locator.SelectOptionOptions options) {
        if (options == null) {
            options = new Locator.SelectOptionOptions();
        }
        return this.frame.selectOption(this.selector, values, Utils.convertType(options, Frame.SelectOptionOptions.class).setStrict(true));
    }

    @Override
    public List<String> selectOption(String[] values, Locator.SelectOptionOptions options) {
        if (options == null) {
            options = new Locator.SelectOptionOptions();
        }
        return this.frame.selectOption(this.selector, values, Utils.convertType(options, Frame.SelectOptionOptions.class).setStrict(true));
    }

    @Override
    public List<String> selectOption(SelectOption values, Locator.SelectOptionOptions options) {
        if (options == null) {
            options = new Locator.SelectOptionOptions();
        }
        return this.frame.selectOption(this.selector, values, Utils.convertType(options, Frame.SelectOptionOptions.class).setStrict(true));
    }

    @Override
    public List<String> selectOption(ElementHandle[] values, Locator.SelectOptionOptions options) {
        if (options == null) {
            options = new Locator.SelectOptionOptions();
        }
        return this.frame.selectOption(this.selector, values, Utils.convertType(options, Frame.SelectOptionOptions.class).setStrict(true));
    }

    @Override
    public List<String> selectOption(SelectOption[] values, Locator.SelectOptionOptions options) {
        if (options == null) {
            options = new Locator.SelectOptionOptions();
        }
        return this.frame.selectOption(this.selector, values, Utils.convertType(options, Frame.SelectOptionOptions.class).setStrict(true));
    }

    @Override
    public void selectText(Locator.SelectTextOptions options) {
        this.withElement((h, o) -> {
            h.selectText((ElementHandle.SelectTextOptions)o);
            return null;
        }, Utils.convertType(options, ElementHandle.SelectTextOptions.class));
    }

    @Override
    public void setChecked(boolean checked, Locator.SetCheckedOptions options) {
        if (options == null) {
            options = new Locator.SetCheckedOptions();
        }
        this.frame.setChecked(this.selector, checked, Utils.convertType(options, Frame.SetCheckedOptions.class).setStrict(true));
    }

    @Override
    public void setInputFiles(Path files, Locator.SetInputFilesOptions options) {
        if (options == null) {
            options = new Locator.SetInputFilesOptions();
        }
        this.frame.setInputFiles(this.selector, files, Utils.convertType(options, Frame.SetInputFilesOptions.class).setStrict(true));
    }

    @Override
    public void setInputFiles(Path[] files, Locator.SetInputFilesOptions options) {
        if (options == null) {
            options = new Locator.SetInputFilesOptions();
        }
        this.frame.setInputFiles(this.selector, files, Utils.convertType(options, Frame.SetInputFilesOptions.class).setStrict(true));
    }

    @Override
    public void setInputFiles(FilePayload files, Locator.SetInputFilesOptions options) {
        if (options == null) {
            options = new Locator.SetInputFilesOptions();
        }
        this.frame.setInputFiles(this.selector, files, Utils.convertType(options, Frame.SetInputFilesOptions.class).setStrict(true));
    }

    @Override
    public void setInputFiles(FilePayload[] files, Locator.SetInputFilesOptions options) {
        if (options == null) {
            options = new Locator.SetInputFilesOptions();
        }
        this.frame.setInputFiles(this.selector, files, Utils.convertType(options, Frame.SetInputFilesOptions.class).setStrict(true));
    }

    @Override
    public void tap(Locator.TapOptions options) {
        if (options == null) {
            options = new Locator.TapOptions();
        }
        this.frame.tap(this.selector, Utils.convertType(options, Frame.TapOptions.class).setStrict(true));
    }

    @Override
    public String textContent(Locator.TextContentOptions options) {
        if (options == null) {
            options = new Locator.TextContentOptions();
        }
        return this.frame.textContent(this.selector, Utils.convertType(options, Frame.TextContentOptions.class).setStrict(true));
    }

    @Override
    public void type(String text, Locator.TypeOptions options) {
        if (options == null) {
            options = new Locator.TypeOptions();
        }
        this.frame.type(this.selector, text, Utils.convertType(options, Frame.TypeOptions.class).setStrict(true));
    }

    @Override
    public void uncheck(Locator.UncheckOptions options) {
        if (options == null) {
            options = new Locator.UncheckOptions();
        }
        this.frame.uncheck(this.selector, Utils.convertType(options, Frame.UncheckOptions.class).setStrict(true));
    }

    @Override
    public void waitFor(Locator.WaitForOptions options) {
        if (options == null) {
            options = new Locator.WaitForOptions();
        }
        this.waitForImpl(options);
    }

    private void waitForImpl(Locator.WaitForOptions options) {
        this.frame.withLogging("Locator.waitFor", () -> this.frame.waitForSelectorImpl(this.selector, Utils.convertType(options, Frame.WaitForSelectorOptions.class).setStrict(true), true));
    }

    public String toString() {
        return "Locator@" + this.selector;
    }

    FrameExpectResult expect(String expression, FrameExpectOptions options) {
        return this.frame.withLogging("Locator.expect", () -> this.expectImpl(expression, options));
    }

    JsonObject toProtocol() {
        JsonObject result = new JsonObject();
        result.add("frame", (JsonElement)this.frame.toProtocolRef());
        result.addProperty("selector", this.selector);
        return result;
    }

    private FrameExpectResult expectImpl(String expression, FrameExpectOptions options) {
        if (options == null) {
            options = new FrameExpectOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", this.selector);
        params.addProperty("expression", expression);
        JsonElement json = this.frame.sendMessage("expect", params);
        FrameExpectResult result = (FrameExpectResult)Serialization.gson().fromJson(json, FrameExpectResult.class);
        return result;
    }

    private static class Filters {
        private final Map<Field, String> filterFieldToEngine = new LinkedHashMap<Field, String>();

        private Filters() {
            try {
                this.addFilter("has", "has");
            }
            catch (NoSuchFieldException e) {
                throw new InternalError(e);
            }
        }

        private void addFilter(String name, String engine) throws NoSuchFieldException {
            this.filterFieldToEngine.put(Locator.LocatorOptions.class.getField(name), engine);
        }

        String addFiltersToSelector(String selector, Locator.LocatorOptions options, Frame frame) {
            try {
                for (Map.Entry<Field, String> p : this.filterFieldToEngine.entrySet()) {
                    LocatorImpl filter = (LocatorImpl)p.getKey().get(options);
                    if (filter == null) continue;
                    if (filter.frame != frame) {
                        throw new PlaywrightException("Inner '" + p.getKey().getName() + "' locator must belong to the same frame.");
                    }
                    selector = selector + " >> " + p.getValue() + "=" + Serialization.gson().toJson((Object)filter.selector);
                }
            }
            catch (IllegalAccessException e) {
                throw new PlaywrightException("Unexpected options", e);
            }
            return selector;
        }
    }
}

