/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.mxml;

import java.util.EnumSet;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.mxml.MXMLDialect2009;
import org.apache.royale.compiler.projects.ICompilerProject;

public class MXMLDialect2012
extends MXMLDialect2009 {
    private static final MXMLDialect INSTANCE = new MXMLDialect2012("http://ns.adobe.com/mxml/2012", 2012);

    public static MXMLDialect getInstance() {
        return INSTANCE;
    }

    protected MXMLDialect2012(String languageNamespace, int year) {
        super(languageNamespace, year);
    }

    @Override
    public boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    @Override
    public String trim(String s) {
        int j;
        int i;
        int n = s.length();
        for (i = 0; i < n && this.isWhitespace(s.charAt(i)); ++i) {
        }
        for (j = n - 1; j >= i && this.isWhitespace(s.charAt(j)); --j) {
        }
        return i > 0 || j < n - 1 ? s.substring(i, j + 1) : s;
    }

    @Override
    public Boolean parseBoolean(ICompilerProject project, String s, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        if (s.equals("true")) {
            return Boolean.TRUE;
        }
        if (s.equals("false")) {
            return Boolean.FALSE;
        }
        return null;
    }
}

