/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.common;

import org.apache.royale.compiler.common.DependencyTypeSet;

public enum DependencyType {
    INHERITANCE('i'),
    SIGNATURE('s'),
    NAMESPACE('n'),
    EXPRESSION('e');

    private final char symbol;

    private DependencyType(char symbol) {
        this.symbol = symbol;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public boolean existsIn(DependencyTypeSet dependencies) {
        return dependencies.contains(this);
    }

    public static DependencyType get(char symbol) {
        switch (symbol) {
            case 'i': {
                return INHERITANCE;
            }
            case 'n': {
                return NAMESPACE;
            }
            case 's': {
                return SIGNATURE;
            }
            case 'e': {
                return EXPRESSION;
            }
        }
        throw new IllegalArgumentException("Invalid symbol: " + symbol);
    }

    public static String getTypeString(DependencyTypeSet types) {
        StringBuilder sb = new StringBuilder();
        if (INHERITANCE.existsIn(types)) {
            sb.append('i');
        }
        if (NAMESPACE.existsIn(types)) {
            sb.append('n');
        }
        if (SIGNATURE.existsIn(types)) {
            sb.append('s');
        }
        if (EXPRESSION.existsIn(types)) {
            sb.append('e');
        }
        return sb.toString();
    }
}

