/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.INumericLiteralNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoLeadingZeroesRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.LiteralIntegerID, (node, tokenQuery, problems) -> this.checkNumericLiteralNode((INumericLiteralNode)node, tokenQuery, problems));
        result.put(ASTNodeID.LiteralNumberID, (node, tokenQuery, problems) -> this.checkNumericLiteralNode((INumericLiteralNode)node, tokenQuery, problems));
        result.put(ASTNodeID.LiteralUintID, (node, tokenQuery, problems) -> this.checkNumericLiteralNode((INumericLiteralNode)node, tokenQuery, problems));
        return result;
    }

    private void checkNumericLiteralNode(INumericLiteralNode numberNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        String stringValue = numberNode.getNumericValue().toString();
        if (!stringValue.startsWith("0")) {
            return;
        }
        if (stringValue.startsWith("0x")) {
            return;
        }
        problems.add(new NoLeadingZeroesLinterProblem(numberNode));
    }

    public static class NoLeadingZeroesLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Must remove leading zeros from numeric literal '${value}'";
        public String value;

        public NoLeadingZeroesLinterProblem(INumericLiteralNode node) {
            super((ISourceLocation)node);
            this.value = node.getNumericValue().toString();
        }
    }
}

