/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.parsing.IMXMLToken;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IDocumentableDefinitionNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.MXMLTokenQuery;
import org.apache.royale.linter.MXMLTokenVisitor;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class MissingASDocRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.ClassID, (node, tokenQuery, problems) -> this.checkDocumentableDefinitionNode((IDocumentableDefinitionNode)node, tokenQuery, problems));
        result.put(ASTNodeID.InterfaceID, (node, tokenQuery, problems) -> this.checkDocumentableDefinitionNode((IDocumentableDefinitionNode)node, tokenQuery, problems));
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkDocumentableDefinitionNode((IDocumentableDefinitionNode)node, tokenQuery, problems));
        result.put(ASTNodeID.VariableID, (node, tokenQuery, problems) -> this.checkDocumentableDefinitionNode((IDocumentableDefinitionNode)node, tokenQuery, problems));
        return result;
    }

    @Override
    public Map<IMXMLToken.MXMLTokenKind, MXMLTokenVisitor> getMXMLTokenVisitors() {
        HashMap<IMXMLToken.MXMLTokenKind, MXMLTokenVisitor> result = new HashMap<IMXMLToken.MXMLTokenKind, MXMLTokenVisitor>();
        result.put(IMXMLToken.MXMLTokenKind.COMMENT, (token, tokenQuery, problems) -> this.checkMXMLComment(token, tokenQuery, problems));
        return result;
    }

    private void checkDocumentableDefinitionNode(IDocumentableDefinitionNode definitionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!definitionNode.hasNamespace("public")) {
            return;
        }
        IASToken token = tokenQuery.getTokenBefore((ISourceLocation)definitionNode, false, true);
        if (token.getType() == 28) {
            String docComment = token.getText();
            if (!this.isDocCommentEmpty(docComment)) {
                return;
            }
            problems.add(new EmptyASDocLinterProblem(token));
            return;
        }
        problems.add(new MissingASDocLinterProblem(definitionNode));
    }

    private boolean isDocCommentEmpty(String docComment) {
        docComment = docComment.substring(3, docComment.length() - 2).trim();
        String[] lines = docComment.split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[0];
            if ((line = line.trim()).startsWith("*")) {
                line = line.substring(1).trim();
            }
            if (line.length() <= 0) continue;
            return false;
        }
        return true;
    }

    private void checkMXMLComment(IMXMLToken comment, MXMLTokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        boolean isASDoc;
        String commentText = comment.getText();
        boolean bl = isASDoc = commentText.startsWith("<!---") && commentText.length() > 7;
        if (!isASDoc) {
            return;
        }
        if ((commentText = commentText.substring(5, commentText.length() - 3).trim()).length() > 0) {
            return;
        }
        problems.add(new EmptyASDocLinterProblem(comment));
    }

    public static class EmptyASDocLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "ASDoc comments must not be empty";

        public EmptyASDocLinterProblem(IASToken token) {
            super(token);
        }

        public EmptyASDocLinterProblem(IMXMLToken token) {
            super((ISourceLocation)token);
        }
    }

    public static class MissingASDocLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Public APIs must have ASDoc comments";

        public MissingASDocLinterProblem(IDocumentableDefinitionNode node) {
            super((ISourceLocation)node);
        }
    }
}

