/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.tree.as.BaseLiteralContainerNode;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;

public class XMLLiteralNode
extends BaseLiteralContainerNode {
    public XMLLiteralNode() {
        super(new LiteralNode(ILiteralNode.LiteralType.XML, ""));
    }

    protected XMLLiteralNode(XMLLiteralNode other) {
        super(other);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.XMLContentID;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.XML);
    }

    @Override
    protected XMLLiteralNode copy() {
        return new XMLLiteralNode(this);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return true;
    }

    @Override
    public ILiteralNode.LiteralType getLiteralType() {
        return ILiteralNode.LiteralType.XML;
    }

    public final String getText() {
        StringBuilder result = new StringBuilder();
        ContainerNode contents = this.getContentsNode();
        for (int i = 0; i < contents.getChildCount(); ++i) {
            IASNode element = contents.getChild(i);
            if (element instanceof LiteralNode) {
                result.append(((LiteralNode)element).getValue());
                continue;
            }
            if (element instanceof IIdentifierNode) {
                result.append("{").append(((IIdentifierNode)element).getName()).append("}");
                continue;
            }
            if (!(element instanceof IMemberAccessExpressionNode)) continue;
            result.append("{").append(((IMemberAccessExpressionNode)element).getDisplayString()).append("}");
        }
        return result.toString();
    }
}

