/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.ConfigConditionBlockNode;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IScopedNode;

public class ScopedBlockNode
extends BlockNode
implements IScopedNode {
    private final boolean compressChildrenOnNormalization;
    protected ASScope scope;

    public ScopedBlockNode() {
        this(true);
    }

    public ScopedBlockNode(boolean compressChildrenOnNormalization) {
        this.compressChildrenOnNormalization = compressChildrenOnNormalization;
    }

    @Override
    public ASScope getASScope() {
        return this.scope;
    }

    @Override
    public IASScope getScope() {
        return this.scope;
    }

    @Override
    public Collection<ICompilerProblem> runPostProcess(EnumSet<PostProcessStep> set, ASScope containingScope) {
        return super.runPostProcess(set, containingScope);
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (scope instanceof TypeScope) {
            TypeScope typeScope = (TypeScope)scope;
            ASScope classScope = typeScope.getStaticScope();
            ASScope instanceScope = typeScope.getInstanceScope();
            List<IASNode> children = ScopedBlockNode.getDescendantStatements(this);
            for (IASNode child : children) {
                if (!(child instanceof NodeBase)) continue;
                if (child.getParent() == null) {
                    ((NodeBase)child).setParent(this);
                }
                ((NodeBase)child).analyze(set, this.childInStaticScope(child) ? classScope : instanceScope, problems);
            }
            if (scope != null) {
                scope.compact();
            }
        } else {
            super.analyze(set, scope, problems);
        }
        if (scope != null) {
            scope.compact();
        }
    }

    private static List<IASNode> getDescendantStatements(IASNode parent) {
        ArrayList<IASNode> ret = new ArrayList<IASNode>();
        int childrenSize = parent.getChildCount();
        for (int i = 0; i < childrenSize; ++i) {
            IASNode child = parent.getChild(i);
            if (child instanceof ConfigConditionBlockNode) {
                ret.addAll(ScopedBlockNode.getDescendantStatements(child));
                continue;
            }
            ret.add(child);
        }
        return ret;
    }

    @Override
    protected final void optimizeChildren(Object newChildren) {
        if (this.compressChildrenOnNormalization) {
            super.optimizeChildren(newChildren);
        }
    }

    @Override
    public void getAllImportNodes(Collection<IImportNode> importNodes) {
        this.collectImportNodes(importNodes);
        IScopedNode parent = (IScopedNode)this.getAncestorOfType(IScopedNode.class);
        if (parent != null) {
            if (!(this.getParent() instanceof PackageNode)) {
                parent.getAllImportNodes(importNodes);
            } else if (parent instanceof FileNode) {
                ((FileNode)parent).collectImplicitImportNodes(importNodes);
            }
        }
    }

    @Override
    public void getAllImports(Collection<String> imports) {
        ArrayList<IImportNode> importNodes = new ArrayList<IImportNode>();
        this.getAllImportNodes(importNodes);
        for (IImportNode importNode : importNodes) {
            imports.add(importNode.getImportName());
        }
    }

    void reconnectScope(ASScope scope) {
        this.scope = scope;
        scope.reconnectScopeNode(this);
    }

    public Collection<ICompilerProblem> runPostProcess(EnumSet<PostProcessStep> set) {
        return this.runPostProcess(set, null);
    }

    public void setScope(ASScope scope) {
        this.scope = scope;
    }

    private boolean childInStaticScope(IASNode child) {
        if (child instanceof BaseDefinitionNode) {
            return ((BaseDefinitionNode)child).hasModifier(ASModifier.STATIC) || child instanceof NamespaceNode;
        }
        return true;
    }
}

