/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.ISwitchNode;
import org.apache.royale.compiler.tree.as.ITerminalNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class SwitchWithoutDefaultRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.SwitchID, (node, tokenQuery, problems) -> this.checkSwitchNode((ISwitchNode)node, tokenQuery, problems));
        return result;
    }

    private void checkSwitchNode(ISwitchNode switchNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        ITerminalNode defaultNode = switchNode.getDefaultNode();
        if (defaultNode != null) {
            return;
        }
        problems.add(new SwitchWithoutDefaultLinterProblem(switchNode));
    }

    public static class SwitchWithoutDefaultLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Missing 'default' clause in 'switch' statement";

        public SwitchWithoutDefaultLinterProblem(ISwitchNode node) {
            super((ISourceLocation)node);
        }
    }
}

