/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryImpl;
import org.apache.qpid.server.queue.SortedQueueEntryList;
import org.apache.qpid.server.store.MessageEnqueueRecord;

public class SortedQueueEntry
extends QueueEntryImpl {
    private volatile SortedQueueEntry _next;
    private SortedQueueEntry _prev;
    private String _key;
    private Colour _colour = Colour.BLACK;
    private SortedQueueEntry _parent;
    private SortedQueueEntry _left;
    private SortedQueueEntry _right;

    public SortedQueueEntry(SortedQueueEntryList queueEntryList) {
        super(queueEntryList);
    }

    public SortedQueueEntry(SortedQueueEntryList queueEntryList, ServerMessage message, long entryId, MessageEnqueueRecord messageEnqueueRecord) {
        super(queueEntryList, message, entryId, messageEnqueueRecord);
    }

    @Override
    public int compareTo(QueueEntry other) {
        SortedQueueEntry o = (SortedQueueEntry)other;
        String otherKey = o._key;
        int compare = this._key == null ? (otherKey == null ? 0 : -1) : (otherKey == null ? 1 : this._key.compareTo(otherKey));
        return compare == 0 ? super.compareTo(o) : compare;
    }

    public Colour getColour() {
        return this._colour;
    }

    public String getKey() {
        return this._key;
    }

    public SortedQueueEntry getLeft() {
        return this._left;
    }

    @Override
    public SortedQueueEntry getNextNode() {
        return this._next;
    }

    @Override
    public SortedQueueEntry getNextValidEntry() {
        return this.getNextNode();
    }

    public SortedQueueEntry getParent() {
        return this._parent;
    }

    public SortedQueueEntry getPrev() {
        return this._prev;
    }

    public SortedQueueEntry getRight() {
        return this._right;
    }

    public void setColour(Colour colour) {
        this._colour = colour;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public void setLeft(SortedQueueEntry left) {
        this._left = left;
    }

    public void setNext(SortedQueueEntry next) {
        this._next = next;
    }

    public void setParent(SortedQueueEntry parent) {
        this._parent = parent;
    }

    public void setPrev(SortedQueueEntry prev) {
        this._prev = prev;
    }

    public void setRight(SortedQueueEntry right) {
        this._right = right;
    }

    @Override
    public String toString() {
        return "(" + (this._colour == Colour.RED ? "Red," : "Black,") + this._key + ")";
    }

    public static enum Colour {
        RED,
        BLACK;

    }
}

