/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.velocity;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class GenericVelocityPortlet
extends GenericServletPortlet {
    public static final String PORTLET_BRIDGE_CONTEXT = "portals.bridges.velocity.context";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        super.processAction(request, actionResponse);
    }

    public void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (request.getAttribute(PORTLET_BRIDGE_CONTEXT) == null) {
            this.createPortletVelocityContext(request, response);
        }
        super.doCustom(request, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (request.getAttribute(PORTLET_BRIDGE_CONTEXT) == null) {
            this.createPortletVelocityContext(request, response);
        }
        super.doEdit(request, response);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (request.getAttribute(PORTLET_BRIDGE_CONTEXT) == null) {
            this.createPortletVelocityContext(request, response);
        }
        super.doHelp(request, response);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doView(request, response);
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.createPortletVelocityContext(request, response);
        super.render(request, response);
    }

    private Context createPortletVelocityContext(RenderRequest request, RenderResponse response) {
        VelocityContext ctx = new VelocityContext();
        request.setAttribute(PORTLET_BRIDGE_CONTEXT, (Object)ctx);
        ctx.put("renderRequest", (Object)request);
        ctx.put("renderResponse", (Object)response);
        ctx.put("portletConfig", (Object)this.getPortletConfig());
        ctx.put("STATE_NORMAL", (Object)WindowState.NORMAL);
        ctx.put("STATE_MAX", (Object)WindowState.MAXIMIZED);
        ctx.put("STATE_MIN", (Object)WindowState.MINIMIZED);
        ctx.put("MODE_VIEW", (Object)PortletMode.VIEW);
        ctx.put("MODE_EDIT", (Object)PortletMode.EDIT);
        ctx.put("MODE_HELP", (Object)PortletMode.HELP);
        ctx.put("USER_INFO", (Object)"javax.portlet.userinfo");
        return ctx;
    }

    public Context getContext(RenderRequest request) {
        return (Context)request.getAttribute(PORTLET_BRIDGE_CONTEXT);
    }

    public Context getContext(RenderRequest request, RenderResponse response) {
        Context context = (Context)request.getAttribute(PORTLET_BRIDGE_CONTEXT);
        if (context == null) {
            context = this.createPortletVelocityContext(request, response);
        }
        return context;
    }

    public void setupPreferencesEdit(RenderRequest request, RenderResponse response) {
        Context context = this.getContext(request, response);
        PortletPreferences prefs = request.getPreferences();
        Map map = prefs.getMap();
        Iterator it = map.entrySet().iterator();
        context.put("prefs", it);
        HashMap result = new HashMap(map.size());
        for (Map.Entry e : map.entrySet()) {
            String[] why = (String[])e.getValue();
            if (why == null || why[0] == null) {
                result.put(e.getKey(), "");
                continue;
            }
            result.put(e.getKey(), why[0]);
        }
        context.put("prefsMap", result);
    }

    public void doPreferencesEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setupPreferencesEdit(request, response);
        super.doEdit(request, response);
    }
}

