/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.composite;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Result;
import org.apache.nifi.toolkit.cli.api.Session;
import org.apache.nifi.toolkit.cli.api.SessionException;
import org.apache.nifi.toolkit.cli.impl.command.AbstractCommand;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.session.SessionVariable;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;

public abstract class AbstractCompositeCommand<R extends Result>
extends AbstractCommand<R> {
    public AbstractCompositeCommand(String name, Class<R> resultClass) {
        super(name, resultClass);
    }

    @Override
    protected final Options createBaseOptions() {
        Options options = new Options();
        options.addOption(CommandOption.NIFI_PROPS.createOption());
        options.addOption(CommandOption.NIFI_REG_PROPS.createOption());
        options.addOption(CommandOption.VERBOSE.createOption());
        return options;
    }

    @Override
    public final R execute(CommandLine cli) throws CommandException {
        try {
            Properties nifiProperties = this.createProperties(cli, CommandOption.NIFI_PROPS, SessionVariable.NIFI_CLIENT_PROPS);
            if (nifiProperties == null) {
                throw new CommandException("Unable to find NiFi config, must specify --" + CommandOption.NIFI_PROPS.getLongName() + ", or setup session config");
            }
            ClientFactory<NiFiClient> nifiClientFactory = this.getContext().getNiFiClientFactory();
            NiFiClient nifiClient = nifiClientFactory.createClient(nifiProperties);
            Properties registryProperties = this.createProperties(cli, CommandOption.NIFI_REG_PROPS, SessionVariable.NIFI_REGISTRY_CLIENT_PROPS);
            if (registryProperties == null) {
                throw new CommandException("Unable to find NiFi Registry config, must specify --" + CommandOption.NIFI_REG_PROPS.getLongName() + ", or setup session config");
            }
            ClientFactory<NiFiRegistryClient> registryClientFactory = this.getContext().getNiFiRegistryClientFactory();
            NiFiRegistryClient registryClient = registryClientFactory.createClient(registryProperties);
            return this.doExecute(cli, nifiClient, nifiProperties, registryClient, registryProperties);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command '" + this.getName() + "' : " + e.getMessage(), e);
        }
    }

    private Properties createProperties(CommandLine commandLine, CommandOption propertyOption, SessionVariable sessionVariable) throws IOException, SessionException {
        Session session;
        String sessionPropsFiles;
        if (commandLine.hasOption(propertyOption.getLongName())) {
            String propertiesFile = commandLine.getOptionValue(propertyOption.getLongName());
            if (!StringUtils.isBlank((CharSequence)propertiesFile)) {
                try (FileInputStream in = new FileInputStream(propertiesFile);){
                    Properties properties = new Properties();
                    properties.load(in);
                    Properties properties2 = properties;
                    return properties2;
                }
            }
        } else if (sessionVariable != null && !StringUtils.isBlank((CharSequence)(sessionPropsFiles = (session = this.getContext().getSession()).get(sessionVariable.getVariableName())))) {
            try (FileInputStream in = new FileInputStream(sessionPropsFiles);){
                Properties properties = new Properties();
                properties.load(in);
                Properties properties3 = properties;
                return properties3;
            }
        }
        return null;
    }

    public abstract R doExecute(CommandLine var1, NiFiClient var2, Properties var3, NiFiRegistryClient var4, Properties var5) throws CommandException, IOException, NiFiRegistryException, ParseException, NiFiClientException;
}

