/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.link;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class JaxbLink {
    private URI uri;
    private Map<String, String> params;

    public JaxbLink() {
    }

    public JaxbLink(URI uri) {
        this.uri = uri;
    }

    public JaxbLink(URI uri, Map<String, String> params) {
        this.uri = uri;
        this.params = params;
    }

    @XmlAttribute(name="href")
    @Schema(name="href", description="The href for the link")
    public URI getUri() {
        return this.uri;
    }

    @XmlAnyAttribute
    @Schema(name="params", description="The params for the link")
    public Map<String, String> getParams() {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        return this.params;
    }

    void setUri(URI uri) {
        this.uri = uri;
    }

    void setParams(Map<String, String> params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JaxbLink)) {
            return false;
        }
        JaxbLink jaxbLink = (JaxbLink)o;
        if (this.uri != null ? !this.uri.equals(jaxbLink.uri) : jaxbLink.uri != null) {
            return false;
        }
        if (this.params == jaxbLink.params) {
            return true;
        }
        if (this.params == null) {
            return jaxbLink.params.isEmpty();
        }
        if (jaxbLink.params == null) {
            return this.params.isEmpty();
        }
        return this.params.equals(jaxbLink.params);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.params != null && !this.params.isEmpty() ? this.params.hashCode() : 0);
        return result;
    }
}

