/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.concurrency;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.nifi.util.concurrency.DebugDisabledTimedLock;
import org.apache.nifi.util.concurrency.DebugEnabledTimedLock;
import org.apache.nifi.util.concurrency.DebuggableTimedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedLock {
    private final DebugEnabledTimedLock enabled;
    private final DebugDisabledTimedLock disabled;
    private final Logger logger;

    public TimedLock(Lock lock, String name, int iterationFrequency) {
        this.enabled = new DebugEnabledTimedLock(lock, name, iterationFrequency);
        this.disabled = new DebugDisabledTimedLock(lock);
        this.logger = LoggerFactory.getLogger((String)(TimedLock.class.getName() + "." + name));
    }

    private DebuggableTimedLock getLock() {
        return this.logger.isDebugEnabled() ? this.enabled : this.disabled;
    }

    public boolean tryLock() {
        return this.getLock().tryLock();
    }

    public boolean tryLock(long timeout, TimeUnit timeUnit) {
        return this.getLock().tryLock(timeout, timeUnit);
    }

    public void lock() {
        this.getLock().lock();
    }

    public void unlock(String task) {
        this.getLock().unlock(task);
    }
}

