/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.azure.security.keyvault.keys.implementation.models.SecretProperties;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public final class SecretKey
implements JsonSerializable<SecretKey> {
    private String value;
    private SecretProperties properties;

    public SecretKey() {
        this.properties = new SecretProperties();
    }

    public SecretKey(String name, String value) {
        this.properties = new SecretProperties(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.properties.getId();
    }

    public String getName() {
        return this.properties.getName();
    }

    public SecretProperties getProperties() {
        return this.properties;
    }

    public SecretKey setProperties(SecretProperties properties) {
        Objects.requireNonNull(properties);
        properties.name = this.properties.name;
        this.properties = properties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("value", this.value);
        if (this.properties != null) {
            jsonWriter.writeMapField("tags", this.properties.getTags(), JsonWriter::writeString).writeStringField("contentType", this.properties.getContentType()).writeStartObject("attributes").writeBooleanField("enabled", this.properties.isEnabled());
            if (this.properties.getNotBefore() != null) {
                jsonWriter.writeNumberField("nbf", (Number)this.properties.getNotBefore().toEpochSecond());
            }
            if (this.properties.getExpiresOn() != null) {
                jsonWriter.writeNumberField("exp", (Number)this.properties.getExpiresOn().toEpochSecond());
            }
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static SecretKey fromJson(JsonReader jsonReader) throws IOException {
        return (SecretKey)jsonReader.readObject(reader -> {
            SecretKey secretKey = new SecretKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    secretKey.value = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    secretKey.properties.id = reader.getString();
                    KeyVaultKeysUtils.unpackId(secretKey.properties.id, name -> {
                        secretKey.properties.name = name;
                    }, version -> {
                        secretKey.properties.version = version;
                    });
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    secretKey.properties.contentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("enabled".equals(fieldName)) {
                            secretKey.properties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("nbf".equals(fieldName)) {
                            secretKey.properties.notBefore = (OffsetDateTime)reader.getNullable(nonNull -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(nonNull.getLong()), ZoneOffset.UTC));
                            continue;
                        }
                        if ("exp".equals(fieldName)) {
                            secretKey.properties.expiresOn = (OffsetDateTime)reader.getNullable(nonNull -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(nonNull.getLong()), ZoneOffset.UTC));
                            continue;
                        }
                        if ("created".equals(fieldName)) {
                            secretKey.properties.createdOn = (OffsetDateTime)reader.getNullable(nonNull -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(nonNull.getLong()), ZoneOffset.UTC));
                            continue;
                        }
                        if ("updated".equals(fieldName)) {
                            secretKey.properties.updatedOn = (OffsetDateTime)reader.getNullable(nonNull -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(nonNull.getLong()), ZoneOffset.UTC));
                            continue;
                        }
                        if ("recoverableDays".equals(fieldName)) {
                            secretKey.properties.recoverableDays = (Integer)reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        if ("recoveryLevel".equals(fieldName)) {
                            secretKey.properties.recoveryLevel = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    secretKey.properties.tags = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    secretKey.properties.keyId = reader.getString();
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    secretKey.properties.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return secretKey;
        });
    }
}

