/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class KeyCreateParameters
implements JsonSerializable<KeyCreateParameters> {
    private KeyType kty;
    private Integer keySize;
    private Integer publicExponent;
    private List<KeyOperation> keyOps;
    private KeyAttributes keyAttributes;
    private Map<String, String> tags;
    private KeyCurveName crv;
    private KeyReleasePolicy releasePolicy;

    public KeyType getKty() {
        return this.kty;
    }

    public KeyCreateParameters setKty(KeyType kty) {
        this.kty = kty;
        return this;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public KeyCreateParameters setKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public Integer getPublicExponent() {
        return this.publicExponent;
    }

    public KeyCreateParameters setPublicExponent(Integer publicExponent) {
        this.publicExponent = publicExponent;
        return this;
    }

    public List<KeyOperation> getKeyOps() {
        return this.keyOps;
    }

    public KeyCreateParameters setKeyOps(List<KeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    public KeyCreateParameters setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public KeyCreateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public KeyCurveName getCrv() {
        return this.crv;
    }

    public KeyCreateParameters setCrv(KeyCurveName crv) {
        this.crv = crv;
        return this;
    }

    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    public KeyCreateParameters setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kty", Objects.toString((Object)this.kty, null));
        jsonWriter.writeNumberField("key_size", (Number)this.keySize);
        jsonWriter.writeNumberField("public_exponent", (Number)this.publicExponent);
        jsonWriter.writeArrayField("key_ops", this.keyOps, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.keyAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("crv", Objects.toString((Object)this.crv, null));
        jsonWriter.writeJsonField("release_policy", (JsonSerializable)this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    public static KeyCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyCreateParameters)jsonReader.readObject(reader -> {
            KeyCreateParameters deserializedKeyCreateParameters = new KeyCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kty".equals(fieldName)) {
                    deserializedKeyCreateParameters.kty = KeyType.fromString(reader.getString());
                    continue;
                }
                if ("key_size".equals(fieldName)) {
                    deserializedKeyCreateParameters.keySize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("public_exponent".equals(fieldName)) {
                    deserializedKeyCreateParameters.publicExponent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("key_ops".equals(fieldName)) {
                    List keyOps;
                    deserializedKeyCreateParameters.keyOps = keyOps = reader.readArray(reader1 -> KeyOperation.fromString(reader1.getString()));
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedKeyCreateParameters.keyAttributes = KeyAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedKeyCreateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("crv".equals(fieldName)) {
                    deserializedKeyCreateParameters.crv = KeyCurveName.fromString(reader.getString());
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    deserializedKeyCreateParameters.releasePolicy = KeyReleasePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyCreateParameters;
        });
    }
}

