/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.security.keyvault.keys.cryptography.implementation.ICryptoTransform;
import com.azure.security.keyvault.keys.cryptography.implementation.RsaEncryption;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

class Rsa15
extends RsaEncryption {
    static final String RSA15 = "RSA/ECB/PKCS1Padding";
    public static final String ALGORITHM_NAME = "RSA1_5";

    Rsa15() {
        super(ALGORITHM_NAME);
    }

    @Override
    public ICryptoTransform createEncryptor(KeyPair keyPair) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return this.createEncryptor(keyPair, null);
    }

    @Override
    public ICryptoTransform createEncryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return new Rsa15Encryptor(keyPair, provider);
    }

    @Override
    public ICryptoTransform createDecryptor(KeyPair keyPair) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return this.createDecryptor(keyPair, null);
    }

    @Override
    public ICryptoTransform createDecryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return new Rsa15Decryptor(keyPair, provider);
    }

    static class Rsa15Encryptor
    implements ICryptoTransform {
        private final Cipher cipher;

        Rsa15Encryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
            this.cipher = provider == null ? Cipher.getInstance(Rsa15.RSA15) : Cipher.getInstance(Rsa15.RSA15, provider);
            this.cipher.init(1, keyPair.getPublic());
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException {
            return this.cipher.doFinal(plaintext);
        }
    }

    static class Rsa15Decryptor
    implements ICryptoTransform {
        private final Cipher cipher;

        Rsa15Decryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
            this.cipher = provider == null ? Cipher.getInstance(Rsa15.RSA15) : Cipher.getInstance(Rsa15.RSA15, provider);
            this.cipher.init(2, keyPair.getPrivate());
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException {
            return this.cipher.doFinal(plaintext);
        }
    }
}

