/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

public class AwsSecretsManagerSensitivePropertyProvider
implements SensitivePropertyProvider {
    private static final String IDENTIFIER_KEY = "aws/secretsmanager";
    private final SecretsManagerClient client;
    private final ObjectMapper objectMapper;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    AwsSecretsManagerSensitivePropertyProvider(SecretsManagerClient client) {
        this.client = client;
        this.objectMapper = new ObjectMapper();
    }

    public String getIdentifierKey() {
        return IDENTIFIER_KEY;
    }

    public boolean isSupported() {
        return this.client != null;
    }

    public String protect(String unprotectedValue, ProtectedPropertyContext context) throws SensitivePropertyProtectionException {
        Objects.requireNonNull(context, "Property context must be provided");
        Objects.requireNonNull(unprotectedValue, "Property value must be provided");
        if (this.client == null) {
            throw new SensitivePropertyProtectionException("AWS Secrets Manager Provider Not Configured");
        }
        try {
            this.writeLock.lock();
            String secretName = context.getContextName();
            Optional<ObjectNode> secretKeyValuesOptional = this.getSecretKeyValues(context);
            ObjectNode secretObject = secretKeyValuesOptional.orElse(this.objectMapper.createObjectNode());
            secretObject.put(context.getPropertyName(), unprotectedValue);
            String secretString = this.objectMapper.writeValueAsString((Object)secretObject);
            if (secretKeyValuesOptional.isPresent()) {
                this.client.putSecretValue(builder -> builder.secretId(secretName).secretString(secretString));
            } else {
                this.client.createSecret(builder -> builder.name(secretName).secretString(secretString));
            }
            String string = context.getContextKey();
            return string;
        }
        catch (JsonProcessingException | SecretsManagerException e) {
            throw new SensitivePropertyProtectionException(String.format("AWS Secrets Manager Secret Could Not Be Stored for [%s]", context), e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unprotect(String protectedValue, ProtectedPropertyContext context) throws SensitivePropertyProtectionException {
        Objects.requireNonNull(context, "Property context must be provided");
        if (this.client == null) {
            throw new SensitivePropertyProtectionException("AWS Secrets Manager Provider Not Configured");
        }
        try {
            String propertyName;
            ObjectNode secretKeyValues;
            this.readLock.lock();
            String propertyValue = null;
            Optional<ObjectNode> secretKeyValuesOptional = this.getSecretKeyValues(context);
            if (secretKeyValuesOptional.isPresent() && (secretKeyValues = secretKeyValuesOptional.get()).has(propertyName = context.getPropertyName())) {
                propertyValue = secretKeyValues.get(propertyName).textValue();
            }
            if (propertyValue == null) {
                throw new SensitivePropertyProtectionException(String.format("AWS Secret Name [%s] Property Name [%s] not found", context.getContextName(), context.getPropertyName()));
            }
            String string = propertyValue;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Optional<ObjectNode> getSecretKeyValues(ProtectedPropertyContext context) {
        try {
            GetSecretValueResponse response = this.client.getSecretValue(builder -> builder.secretId(context.getContextName()));
            if (response.secretString() == null) {
                throw new SensitivePropertyProtectionException(String.format("AWS Secret Name [%s] string value not found", context.getContextKey()));
            }
            JsonNode responseNode = this.objectMapper.readTree(response.secretString());
            if (!(responseNode instanceof ObjectNode)) {
                throw new SensitivePropertyProtectionException(String.format("AWS Secrets Manager Secret [%s] JSON parsing failed", context.getContextKey()));
            }
            return Optional.of((ObjectNode)responseNode);
        }
        catch (ResourceNotFoundException e) {
            return Optional.empty();
        }
        catch (SecretsManagerException e) {
            throw new SensitivePropertyProtectionException(String.format("AWS Secrets Manager Secret [%s] retrieval failed", context.getContextKey()), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new SensitivePropertyProtectionException(String.format("AWS Secrets Manager Secret [%s] JSON parsing failed", context.getContextKey()), (Throwable)e);
        }
    }

    public void cleanUp() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

