/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.SslContextBuilder;
import org.apache.nifi.security.ssl.StandardTrustManagerBuilder;

public class StandardSslContextBuilder
implements SslContextBuilder {
    private static final String DEFAULT_PROTOCOL = "TLS";
    private String protocol = "TLS";
    private KeyStore keyStore;
    private char[] keyPassword;
    private KeyStore trustStore;

    @Override
    public SSLContext build() {
        SSLContext sslContext = this.getSslContext();
        SecureRandom secureRandom = new SecureRandom();
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        try {
            sslContext.init(keyManagers, trustManagers, secureRandom);
        }
        catch (KeyManagementException e) {
            throw new BuilderConfigurationException("SSLContext initialization failed", e);
        }
        return sslContext;
    }

    public StandardSslContextBuilder protocol(String protocol) {
        this.protocol = Objects.requireNonNull(protocol, "Protocol required");
        return this;
    }

    public StandardSslContextBuilder keyStore(KeyStore keyStore) {
        this.keyStore = Objects.requireNonNull(keyStore, "Key Store required");
        return this;
    }

    public StandardSslContextBuilder keyPassword(char[] keyPassword) {
        this.keyPassword = Objects.requireNonNull(keyPassword, "Key Password required");
        return this;
    }

    public StandardSslContextBuilder trustStore(KeyStore trustStore) {
        this.trustStore = Objects.requireNonNull(trustStore, "Trust Store required");
        return this;
    }

    private KeyManager[] getKeyManagers() {
        KeyManager[] keyManagers;
        if (this.keyStore == null) {
            keyManagers = null;
        } else {
            KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory();
            try {
                keyManagerFactory.init(this.keyStore, this.keyPassword);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new BuilderConfigurationException("Key Manager initialization failed", e);
            }
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        return keyManagers;
    }

    private TrustManager[] getTrustManagers() {
        TrustManager[] trustManagers;
        if (this.trustStore == null) {
            trustManagers = null;
        } else {
            X509TrustManager trustManager = new StandardTrustManagerBuilder().trustStore(this.trustStore).build();
            trustManagers = new TrustManager[]{trustManager};
        }
        return trustManagers;
    }

    private KeyManagerFactory getKeyManagerFactory() {
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        try {
            return KeyManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            String message = String.format("KeyManagerFactory creation failed with algorithm [%s]", algorithm);
            throw new BuilderConfigurationException(message, e);
        }
    }

    private SSLContext getSslContext() {
        try {
            return SSLContext.getInstance(this.protocol);
        }
        catch (NoSuchAlgorithmException e) {
            String message = String.format("SSLContext creation failed with protocol [%s]", this.protocol);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

