/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ui;

import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectGroup;
import org.netbeans.api.project.ui.ProjectGroupChangeListener;
import org.netbeans.modules.project.uiapi.BaseUtilities;
import org.netbeans.modules.project.uiapi.OpenProjectsTrampoline;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Parameters;

public final class OpenProjects {
    public static final String PROPERTY_OPEN_PROJECTS = "openProjects";
    public static final String PROPERTY_MAIN_PROJECT = "MainProject";
    private static final Map<OpenProjectsTrampoline, Reference<OpenProjects>> instances = new WeakHashMap<OpenProjectsTrampoline, Reference<OpenProjects>>();
    private static final Logger LOG = Logger.getLogger(OpenProjects.class.getName());
    private final OpenProjectsTrampoline trampoline;

    private OpenProjects(@NonNull OpenProjectsTrampoline spi) {
        Parameters.notNull("spi", spi);
        this.trampoline = spi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenProjects getDefault() {
        OpenProjectsTrampoline spi = BaseUtilities.getOpenProjectsTrampoline();
        assert (spi != null);
        Map<OpenProjectsTrampoline, Reference<OpenProjects>> map = instances;
        synchronized (map) {
            OpenProjects api;
            Reference<OpenProjects> apiRef = instances.get(spi);
            if (apiRef == null || (api = apiRef.get()) == null) {
                api = new OpenProjects(spi);
                instances.put(spi, new WeakReference<OpenProjects>(api));
            }
            return api;
        }
    }

    public Project[] getOpenProjects() {
        return this.trampoline.getOpenProjectsAPI();
    }

    public Future<Project[]> openProjects() {
        return this.trampoline.openProjectsAPI();
    }

    public void open(Project[] projects, boolean openSubprojects) {
        if (Arrays.asList(projects).contains(null)) {
            throw new NullPointerException();
        }
        this.trampoline.openAPI(projects, openSubprojects, false);
    }

    public void open(Project[] projects, boolean openSubprojects, boolean showProgress) {
        if (Arrays.asList(projects).contains(null)) {
            throw new NullPointerException();
        }
        this.trampoline.openAPI(projects, openSubprojects, showProgress);
    }

    public boolean isProjectOpen(Project p) {
        if (p == null) {
            return false;
        }
        for (Project real : this.getOpenProjects()) {
            if (p.equals(real) || real.equals(p)) {
                LOG.log(Level.FINE, "isProjectOpen => true for {0} @{1} ~ real @{2}", new Object[]{p, p.hashCode(), real.hashCode()});
                return true;
            }
            LOG.log(Level.FINER, "distinct from {0} @{1}", new Object[]{real, real.hashCode()});
        }
        LOG.log(Level.FINE, "isProjectOpen => false for {0} @{1}", new Object[]{p, p.hashCode()});
        return false;
    }

    public void close(Project[] projects) {
        this.trampoline.closeAPI(projects);
    }

    public Project getMainProject() {
        return this.trampoline.getMainProject();
    }

    public void setMainProject(Project project) {
        this.trampoline.setMainProject(project);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.trampoline.addPropertyChangeListenerAPI(listener, this);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.trampoline.removePropertyChangeListenerAPI(listener);
    }

    @CheckForNull
    public ProjectGroup getActiveProjectGroup() {
        return this.trampoline.getActiveProjectGroupAPI();
    }

    public void addProjectGroupChangeListener(@NonNull ProjectGroupChangeListener listener) {
        this.trampoline.addProjectGroupChangeListenerAPI(listener);
    }

    public void removeProjectGroupChangeListener(@NonNull ProjectGroupChangeListener listener) {
        this.trampoline.removeProjectGroupChangeListenerAPI(listener);
    }

    public ExplorerManager createLogicalView() {
        return this.trampoline.createLogicalView();
    }

    public ExplorerManager createPhysicalView() {
        return this.trampoline.createPhysicalView();
    }
}

