// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/
package org.apache.myfaces.trinidad.component;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.context.ComponentContextManager;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.SuspendedContextChanges;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/**
 *
 * <h4>Events:</h4>
 * <table border="1" width="100%" cellpadding="3" summary="">
 * <tr bgcolor="#CCCCFF" class="TableHeadingColor">
 * <th align="left">Type</th>
 * <th align="left">Phases</th>
 * <th align="left">Description</th>
 * </tr>
 * <tr class="TableRowColor">
 * <td valign="top"><code>org.apache.myfaces.trinidad.event.AttributeChangeEvent</code></td>
 * <td valign="top" nowrap>Invoke<br>Application<br>Apply<br>Request<br>Values</td>
 * <td valign="top">Event delivered to describe an attribute change.  Attribute change events are not delivered for any programmatic change to a property.  They are only delivered when a renderer changes a property without the application's specific request.  An example of an attribute change event might include the width of a column that supported client-side resizing.</td>
 * </tr>
 * </table>
 */
public class UIXDocument extends UIXComponentBase
{
  static public final FacesBean.Type TYPE = new FacesBean.Type(
    UIXComponentBase.TYPE);

  static public final String COMPONENT_FAMILY =
    "org.apache.myfaces.trinidad.Document";
  static public final String COMPONENT_TYPE =
    "org.apache.myfaces.trinidad.Document";

  /**
   * Construct an instance of the UIXDocument.
   */
  public UIXDocument()
  {
    super("org.apache.myfaces.trinidad.Document");
  }
    /**
   * Suspends any context changes before allowing invokeOnComponent or visitTree calls to continue,
   * allowing components to undo any context changes during a re-entrant call.
   * @param facesContext the faces context
   * @see ComponentContextManager#suspend(FacesContext)
   */
  @Override
  protected void setupVisitingContext(FacesContext facesContext)
  {
    ComponentContextManager ctxMgr = RequestContext.getCurrentInstance()
      .getComponentContextManager();

    // Suspend any current component context during a visit tree for re-entrant
    // component tree processing
    SuspendedContextChanges suspendedChanges = ctxMgr.suspend(facesContext);

    Map<String, Object> reqMap = facesContext.getExternalContext().getRequestMap();
    @SuppressWarnings("unchecked")
    Queue<SuspendedContextChanges> suspendedChangesQueue = (Queue<SuspendedContextChanges>)
      reqMap.get(_SUSPENDED_CHANGES_KEY);
    if (suspendedChangesQueue == null)
    {
      suspendedChangesQueue = Collections.asLifoQueue(new ArrayDeque<SuspendedContextChanges>());
      reqMap.put(_SUSPENDED_CHANGES_KEY, suspendedChangesQueue);
    }

    suspendedChangesQueue.offer(suspendedChanges);
    _LOG.fine("UIXDocument suspended context changes in setupVisitingContext");

    super.setupVisitingContext(facesContext);
  }

  /**
   * Re-applies the suspended context changes.
   * @param facesContext the faces context
   * @see #setupVisitingContext(FacesContext)
   * @see ComponentContextManager#resume(FacesContext, SuspendedContextChanges)
   */
  @Override
  protected void tearDownVisitingContext(FacesContext facesContext)
  {
    super.tearDownVisitingContext(facesContext);

    ComponentContextManager ctxMgr = RequestContext.getCurrentInstance()
      .getComponentContextManager();
    Map<String, Object> reqMap = facesContext.getExternalContext().getRequestMap();
    @SuppressWarnings("unchecked")
    Queue<SuspendedContextChanges> suspendedChangesQueue = (Queue<SuspendedContextChanges>)
      reqMap.get(_SUSPENDED_CHANGES_KEY);
    SuspendedContextChanges changes = suspendedChangesQueue.poll();
    ctxMgr.resume(facesContext, changes);
    _LOG.fine("UIXDocument resumed context changes in setupVisitingContext");
  }

  private final static String _SUSPENDED_CHANGES_KEY = UIXDocument.class.getName() +
                                                       ".SUSPENDED_CHANGES";
  private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXDocument.class);

  @Override
  public String getFamily()
  {
    return COMPONENT_FAMILY;
  }

  @Override
  protected FacesBean.Type getBeanType()
  {
    return TYPE;
  }

  /**
   * Construct an instance of the UIXDocument.
   */
  protected UIXDocument(
    String rendererType
    )
  {
    super(rendererType);
  }

  static
  {
    TYPE.lockAndRegister("org.apache.myfaces.trinidad.Document","org.apache.myfaces.trinidad.Document");
  }
}
