/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.style;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.trinidad.style.Selector;
import org.apache.myfaces.trinidad.style.Style;

public abstract class Styles {
    public abstract Map<Selector, Style> getSelectorStyleMap();

    public abstract String getNativeSelectorString(Selector var1);

    public Set<Selector> getSelectorsForSimpleSelector(String simpleSelector) {
        Map<Selector, Style> selectorStyleMap = this.getSelectorStyleMap();
        HashSet<Selector> set = null;
        for (Map.Entry<Selector, Style> entry : selectorStyleMap.entrySet()) {
            Selector completeSelector = entry.getKey();
            String completeSelectorString = completeSelector.toString();
            int index = completeSelectorString.indexOf(simpleSelector);
            boolean beforeSelectorOk = false;
            boolean afterSelectorOk = false;
            if (index <= -1) continue;
            if (index == 0) {
                beforeSelectorOk = true;
            } else {
                char c = completeSelectorString.charAt(index - 1);
                if (Character.isWhitespace(c) || c == '.') {
                    beforeSelectorOk = true;
                }
            }
            if (beforeSelectorOk) {
                int endIndex = index + simpleSelector.length();
                if (endIndex < completeSelectorString.length()) {
                    char c = completeSelectorString.charAt(endIndex);
                    if (Character.isWhitespace(c) || c == '.' || c == ':') {
                        afterSelectorOk = true;
                    }
                } else {
                    afterSelectorOk = true;
                }
            }
            if (!beforeSelectorOk || !afterSelectorOk) continue;
            if (set == null) {
                set = new HashSet<Selector>();
            }
            set.add(completeSelector);
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }
}

