/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.DynamicResourceLoader;
import org.apache.myfaces.trinidad.resource.ResourceLoader;
import org.apache.myfaces.trinidad.util.URLUtils;

public class AggregatingResourceLoader
extends DynamicResourceLoader {
    private final String[] _paths;
    private final ResourceLoader _target;
    private volatile String _separator;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(AggregatingResourceLoader.class);

    public AggregatingResourceLoader(String path, String[] paths, ResourceLoader target, ResourceLoader parent) {
        super(path, parent);
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("No paths specified");
        }
        if (target == null) {
            throw new NullPointerException();
        }
        this._paths = (String[])paths.clone();
        this._target = target;
    }

    public AggregatingResourceLoader(String path, String[] paths, ResourceLoader target) {
        this(path, paths, target, null);
    }

    public void setSeparator(String separator) {
        this._separator = separator;
    }

    @Override
    protected URL getURL(String path) throws IOException {
        int len = this._paths.length;
        ArrayList<URL> urls = new ArrayList<URL>(len);
        for (int i = 0; i < len; ++i) {
            URL u = this._target.getResource(this._paths[i]);
            if (u != null) {
                urls.add(u);
                continue;
            }
            _LOG.warning("RESOURCE_NOT_FOUND", new Object[]{this._paths[i], path});
        }
        if (!urls.isEmpty()) {
            urls.trimToSize();
            URL[] urlArray = urls.toArray(new URL[urls.size()]);
            AggregatingURLStreamHandler handler = new AggregatingURLStreamHandler(urlArray, this._separator);
            return new URL("aggregating", null, -1, path, handler);
        }
        throw new IOException("Could not find any of:" + Arrays.toString(this._paths));
    }

    private static class SeparatorInputStream
    extends InputStream {
        private final byte[] _separator;
        private final int _length;
        private volatile int _index = 0;

        public SeparatorInputStream(byte[] separatorBytes) {
            this._separator = separatorBytes;
            this._length = this._separator.length;
        }

        @Override
        public int read() throws IOException {
            if (this._index < this._length) {
                return this._separator[this._index++];
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesLeft = this.available();
            if (len <= bytesLeft) {
                System.arraycopy(this._separator, this._index, b, off, len);
                this._index += len;
                return len;
            }
            System.arraycopy(this._separator, this._index, b, off, bytesLeft);
            this._index += bytesLeft;
            return bytesLeft;
        }

        @Override
        public long skip(long n) throws IOException {
            int bytesLeft = this.available();
            if (n < 0L) {
                return 0L;
            }
            if (n < (long)bytesLeft || n == (long)bytesLeft) {
                this._index = (int)((long)this._index + n);
                return n;
            }
            this._index += bytesLeft;
            return bytesLeft;
        }

        @Override
        public int available() throws IOException {
            return this._length - this._index;
        }
    }

    private static class ArrayEnumeration<T>
    implements Enumeration<T> {
        private final T[] _array;
        private final int _len;
        private volatile int _pointer = 0;

        public ArrayEnumeration(T[] array) {
            if (array == null) {
                throw new NullPointerException();
            }
            this._array = array;
            this._len = array.length;
        }

        public boolean hasNext() {
            return this._pointer < this._len;
        }

        @Override
        public T nextElement() throws NoSuchElementException {
            try {
                return this._array[this._pointer++];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private static class AggregatingURLConnection
    extends URLConnection {
        private volatile int _contentLength = Integer.MIN_VALUE;
        private final URLConnection[] _connections;
        private final byte[] _separator;

        public AggregatingURLConnection(URL url, URLConnection[] connections, String separator) {
            super(url);
            if (connections == null || connections.length == 0) {
                throw new IllegalArgumentException("No connections specified");
            }
            this._connections = connections;
            this._separator = separator != null ? separator.getBytes() : null;
        }

        @Override
        public void connect() throws IOException {
            int len = this._connections.length;
            for (int i = 0; i < len; ++i) {
                this._connections[i].connect();
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            boolean hasseparator = this._separator != null;
            InputStream[] streams = hasseparator ? new InputStream[this._connections.length * 2 - 1] : new InputStream[this._connections.length];
            int i = 0;
            int len = this._connections.length;
            int sublen = len - 1;
            int streamCounter = 0;
            while (i < len) {
                streams[streamCounter] = this._connections[i].getInputStream();
                if (hasseparator && i < sublen) {
                    streams[++streamCounter] = new SeparatorInputStream(this._separator);
                }
                ++i;
                ++streamCounter;
            }
            return new SequenceInputStream(new ArrayEnumeration<InputStream>(streams));
        }

        @Override
        public String getContentType() {
            return this._connections[0].getContentType();
        }

        @Override
        public int getContentLength() {
            int totalContentLength = this._contentLength;
            if (totalContentLength == Integer.MIN_VALUE) {
                totalContentLength = 0;
                URLConnection[] connects = this._connections;
                if (this._separator != null) {
                    totalContentLength += (connects.length - 1) * this._separator.length;
                }
                int len = this._connections.length;
                for (int i = 0; i < len; ++i) {
                    int contentLength = this._connections[i].getContentLength();
                    if (contentLength < 0) {
                        totalContentLength = -1;
                        break;
                    }
                    totalContentLength += contentLength;
                }
                this._contentLength = totalContentLength;
            }
            return totalContentLength;
        }

        @Override
        public long getLastModified() {
            long maxLastModified = -1L;
            int len = this._connections.length;
            for (int i = 0; i < len; ++i) {
                long lastModified;
                try {
                    lastModified = URLUtils.getLastModified(this._connections[i]);
                }
                catch (IOException exception) {
                    maxLastModified = -1L;
                    break;
                }
                if (lastModified < 0L) {
                    maxLastModified = lastModified;
                    break;
                }
                maxLastModified = Math.max(maxLastModified, lastModified);
            }
            return maxLastModified;
        }

        @Override
        public String getHeaderField(String name) {
            if ("content-length".equals(name)) {
                return String.valueOf(this.getContentLength());
            }
            if ("content-type".equals(name)) {
                return this.getContentType();
            }
            if ("last-modified".equals(name)) {
                return String.valueOf(this.getLastModified());
            }
            return super.getHeaderField(name);
        }
    }

    public class AggregatingURLStreamHandler
    extends URLStreamHandler {
        private final URL[] _urls;
        private final String _separator;

        public AggregatingURLStreamHandler(URL[] urls) {
            this(urls, null);
        }

        public AggregatingURLStreamHandler(URL[] urls, String separator) {
            if (urls == null || urls.length == 0) {
                throw new IllegalArgumentException("No URLS specified");
            }
            this._urls = (URL[])urls.clone();
            this._separator = separator;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            int len = this._urls.length;
            URLConnection[] conn = new URLConnection[len];
            for (int i = 0; i < len; ++i) {
                conn[i] = this._urls[i].openConnection();
            }
            return new AggregatingURLConnection(u, conn, this._separator);
        }
    }
}

