/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.internal.component.AbstractUICollapsiblePanel;
import org.apache.myfaces.tobago.internal.component.AbstractUIOffcanvas;
import org.apache.myfaces.tobago.internal.renderkit.renderer.CollapsiblePanelRendererBase;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.layout.OffcanvasPlacement;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class OffcanvasRenderer<T extends AbstractUIOffcanvas>
extends CollapsiblePanelRendererBase<T> {
    private static final String SUFFIX_LABEL = "::label";

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        boolean collapsed = ((AbstractUICollapsiblePanel)component).isCollapsed();
        OffcanvasPlacement placement = ((AbstractUIOffcanvas)component).getPlacement();
        UIComponent labelFacet = ComponentUtils.getFacet(component, Facets.label);
        UIComponent barFacet = ComponentUtils.getFacet(component, Facets.bar);
        writer.startElement(HtmlElements.TOBAGO_OFFCANVAS);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(BootstrapClass.OFFCANVAS, OffcanvasPlacement.top.equals((Object)placement) ? BootstrapClass.OFFCANVAS_TOP : null, OffcanvasPlacement.left.equals((Object)placement) ? BootstrapClass.OFFCANVAS_START : null, OffcanvasPlacement.right.equals((Object)placement) ? BootstrapClass.OFFCANVAS_END : null, OffcanvasPlacement.bottom.equals((Object)placement) ? BootstrapClass.OFFCANVAS_BOTTOM : null);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, -1);
        writer.writeAttribute(Arias.LABELLEDBY, component.getClientId(facesContext), false);
        if (((AbstractUICollapsiblePanel)component).getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
        if (labelFacet != null || barFacet != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.OFFCANVAS_HEADER);
            writer.startElement(HtmlElements.H1);
            writer.writeIdAttribute(component.getClientId(facesContext) + SUFFIX_LABEL);
            writer.writeClassAttribute(BootstrapClass.OFFCANVAS_TITLE);
            if (labelFacet != null) {
                this.insideBegin(facesContext, Facets.label);
                for (UIComponent child : RenderUtils.getFacetChildren(labelFacet)) {
                    child.encodeAll(facesContext);
                }
                this.insideEnd(facesContext, Facets.label);
            }
            writer.endElement(HtmlElements.H1);
            if (barFacet != null) {
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(TobagoClass.BAR);
                this.insideBegin(facesContext, Facets.bar);
                for (UIComponent child : RenderUtils.getFacetChildren(barFacet)) {
                    child.encodeAll(facesContext);
                }
                this.insideEnd(facesContext, Facets.bar);
                writer.endElement(HtmlElements.DIV);
            }
            writer.endElement(HtmlElements.DIV);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.OFFCANVAS_BODY);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.TOBAGO_OFFCANVAS);
    }
}

