/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.formatter;

import aQute.lib.date.Dates;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Formatters {
    private static final Pattern FORMATTER_P = Pattern.compile("%(?<argument>(?<index>\\d+)\\$|<)?[-#+ 0,(]*\\d*(?:\\.\\d+)?(?<conversion>[bBhHsScCdoxXeEfgGaA%n]|(?:[tT][HIklMSLNpzZsQBbhAaCYyjmdeRTrDFc]))");
    private static final Pattern FLOATING_ZERO = Pattern.compile("[-+]?0+\\.0+[dDfF]?");

    public static String format(String format, Function<String, Boolean> isTruthy, int offset, String ... args) {
        Object[] formatArgs = new Object[args.length - offset];
        Matcher m = FORMATTER_P.matcher(format);
        int automatic = 0;
        block9: while (m.find()) {
            int index;
            char conversion = m.group("conversion").charAt(0);
            if (conversion == 'n' || conversion == '%') continue;
            if (m.group("argument") != null) {
                String indexString = m.group("index");
                if (indexString == null) continue;
                index = Integer.parseInt(indexString) - 1;
            } else {
                index = automatic++;
            }
            String arg = args[index + offset];
            switch (conversion) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    formatArgs[index] = Long.valueOf(arg);
                    continue block9;
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    formatArgs[index] = Double.valueOf(arg);
                    continue block9;
                }
                case 'C': 
                case 'c': {
                    if (arg.length() == 1) {
                        formatArgs[index] = Character.valueOf(arg.charAt(0));
                        continue block9;
                    }
                    try {
                        Integer parseInt = Integer.valueOf(arg);
                        formatArgs[index] = parseInt;
                        continue block9;
                    }
                    catch (NumberFormatException ne) {
                        throw new IllegalArgumentException("Character expected but found '" + arg + "'");
                    }
                }
                case 'B': 
                case 'b': {
                    formatArgs[index] = isTruthy.apply(arg.toLowerCase(Locale.ROOT));
                    continue block9;
                }
                case 'T': 
                case 't': {
                    ZonedDateTime date = Dates.parse(arg);
                    if (date == null) {
                        throw new IllegalArgumentException("Illegal Date Format " + arg);
                    }
                    formatArgs[index] = date;
                    continue block9;
                }
            }
            formatArgs[index] = arg;
        }
        return String.format(Locale.ROOT, format, formatArgs);
    }

    public static String format(String format, String ... args) {
        return Formatters.format(format, Formatters::isTruthy, 0, args);
    }

    private static Boolean isTruthy(String arg) {
        if (arg == null) {
            return Boolean.FALSE;
        }
        if ((arg = arg.trim()).isEmpty()) {
            return Boolean.FALSE;
        }
        if ("false".equalsIgnoreCase(arg)) {
            return Boolean.FALSE;
        }
        if ("0".equals(arg)) {
            return Boolean.FALSE;
        }
        if (FLOATING_ZERO.matcher(arg).matches()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

