/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.maven;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.verifier.VerifierPlugin;

@BndPlugin(name="CentralCheck")
public class CentralCheck
implements VerifierPlugin {
    @Override
    public void verify(Analyzer analyzer) throws Exception {
        String version;
        String pom = analyzer.getProperty("-pom");
        if (!Processor.isTrue(pom)) {
            return;
        }
        Attrs pomProperties = OSGiHeader.parseProperties(pom);
        String groupId = pomProperties.get("groupid");
        if (groupId == null) {
            this.check(analyzer, "-groupid");
        }
        if ((version = pomProperties.get("version")) == null) {
            this.check(analyzer, "Bundle-Version");
        }
        this.check(analyzer, "Bundle-DocURL");
        this.check(analyzer, "Bundle-License");
        this.check(analyzer, "Bundle-Developers");
        this.check(analyzer, "Bundle-SCM");
    }

    private void check(Analyzer analyzer, String key) throws Exception {
        String value = analyzer.getProperty(key);
        if (value == null) {
            analyzer.warning("Maven Central Check: %s not set", key);
        }
    }
}

