/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import java.util.Arrays;
import org.apache.felix.metatype.internal.BaseProviderHolder;
import org.apache.felix.metatype.internal.MetaTypeServiceImpl;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.MetaTypeProvider;

class ManagedServiceHolder
extends BaseProviderHolder {
    private String[] pids;
    private boolean isSingleton;
    private boolean isFactory;

    ManagedServiceHolder(ServiceReference reference, MetaTypeProvider provider) {
        super(reference, provider);
        this.pids = BaseProviderHolder.getServicePids(reference);
        this.isSingleton = ManagedServiceHolder.isService(reference, "org.osgi.service.cm.ManagedService");
        this.isFactory = ManagedServiceHolder.isService(reference, "org.osgi.service.cm.ManagedServiceFactory");
    }

    String[] getPids() {
        return this.pids;
    }

    boolean isSingleton() {
        return this.isSingleton;
    }

    boolean isFactory() {
        return this.isFactory;
    }

    void update(MetaTypeServiceImpl mts) {
        Object[] newPids = BaseProviderHolder.getServicePids(this.getReference());
        if (!Arrays.equals(this.getPids(), newPids)) {
            mts.removeService(this);
            this.pids = newPids;
            mts.addService(this);
        }
    }

    private static boolean isService(ServiceReference ref, String type) {
        String[] oc = (String[])ref.getProperty("objectClass");
        if (oc != null) {
            for (int i = 0; i < oc.length; ++i) {
                if (!oc[i].equals(type)) continue;
                return true;
            }
        }
        return false;
    }
}

