/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLong;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;

public class LogEntryImpl
implements LogEntry {
    private static AtomicLong seq = new AtomicLong(0L);
    private String m_name;
    private long m_time;
    private WeakReference<Bundle> m_bundle;
    private WeakReference<ServiceReference> m_service;
    private int m_level;
    private LogLevel m_logLevel;
    private String m_message;
    private Throwable m_exception;
    private String m_thread;
    private Long m_seq;

    public LogEntryImpl(String name, Bundle bundle, ServiceReference service, LogLevel level, String message, Throwable exception) {
        if (bundle != null) {
            this.m_bundle = new WeakReference<Bundle>(bundle);
        }
        if (service != null) {
            this.m_service = new WeakReference<ServiceReference>(service);
        }
        this.m_logLevel = level;
        this.m_level = level.ordinal();
        this.m_message = message;
        this.m_exception = exception;
        this.m_time = System.currentTimeMillis();
        this.m_name = name;
        this.m_thread = Thread.currentThread().getName();
        this.m_seq = seq.incrementAndGet();
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundle == null ? null : (Bundle)this.m_bundle.get();
    }

    public ServiceReference getServiceReference() {
        return this.m_service == null ? null : (ServiceReference)this.m_service.get();
    }

    @Override
    public int getLevel() {
        return this.m_level;
    }

    @Override
    public String getMessage() {
        return this.m_message;
    }

    @Override
    public Throwable getException() {
        return this.m_exception;
    }

    @Override
    public long getTime() {
        return this.m_time;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.m_logLevel;
    }

    @Override
    public String getLoggerName() {
        return this.m_name;
    }

    @Override
    public long getSequence() {
        return this.m_seq;
    }

    @Override
    public String getThreadInfo() {
        return this.m_thread;
    }

    @Override
    public StackTraceElement getLocation() {
        return null;
    }
}

