/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.krb5;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class Krb5LoginModule
implements LoginModule {
    private com.sun.security.auth.module.Krb5LoginModule loginModule = new com.sun.security.auth.module.Krb5LoginModule();

    @Override
    public void initialize(Subject _subject, CallbackHandler _callbackHandler, Map<String, ?> _sharedState, Map<String, ?> _options) {
        HashMap options = new HashMap(_options);
        for (Map.Entry<String, ?> entry : _options.entrySet()) {
            if (entry.getValue() instanceof String) {
                options.put(entry.getKey(), Krb5LoginModule.interpolate((String)entry.getValue()));
                continue;
            }
            options.put(entry.getKey(), entry.getValue());
        }
        this.loginModule.initialize(_subject, _callbackHandler, _sharedState, options);
    }

    @Override
    public boolean login() throws LoginException {
        return this.loginModule.login();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.loginModule.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.loginModule.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.loginModule.logout();
    }

    private static String interpolate(String _value) {
        String value = _value;
        Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(value);
        while (matcher.find()) {
            String rep = System.getProperty(matcher.group(1));
            if (rep == null) continue;
            value = value.replace(matcher.group(0), rep);
            matcher.reset(value);
        }
        return value;
    }
}

