/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.scp;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.client.scp.CloseableScpClient;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.scp.ScpClientCreator;
import org.apache.sshd.client.scp.SimpleScpClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class SimpleScpClientImpl
extends AbstractLoggingBean
implements SimpleScpClient {
    private SimpleClient clientInstance;
    private ScpClientCreator scpClientCreator;

    public SimpleScpClientImpl() {
        this(null);
    }

    public SimpleScpClientImpl(SimpleClient client) {
        this(client, null);
    }

    public SimpleScpClientImpl(SimpleClient client, ScpClientCreator scpClientCreator) {
        this.clientInstance = client;
        this.setScpClientCreator(scpClientCreator);
    }

    public SimpleClient getClient() {
        return this.clientInstance;
    }

    public void setClient(SimpleClient client) {
        this.clientInstance = client;
    }

    public ScpClientCreator getScpClientCreator() {
        return this.scpClientCreator;
    }

    public void setScpClientCreator(ScpClientCreator scpClientCreator) {
        this.scpClientCreator = scpClientCreator == null ? ScpClientCreator.instance() : scpClientCreator;
    }

    @Override
    public CloseableScpClient scpLogin(SocketAddress target, String username, String password) throws IOException {
        return this.createScpClient((IOFunction<? super SimpleClient, ? extends ClientSession>)((IOFunction)client -> client.sessionLogin(target, username, password)));
    }

    @Override
    public CloseableScpClient scpLogin(SocketAddress target, String username, KeyPair identity) throws IOException {
        return this.createScpClient((IOFunction<? super SimpleClient, ? extends ClientSession>)((IOFunction)client -> client.sessionLogin(target, username, identity)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableScpClient createScpClient(IOFunction<? super SimpleClient, ? extends ClientSession> sessionProvider) throws IOException {
        SimpleClient client = this.getClient();
        try (ClientSession session = (ClientSession)sessionProvider.apply((Object)client);){
            CloseableScpClient scp = this.createScpClient(session);
            session = null;
            CloseableScpClient closeableScpClient = scp;
            return closeableScpClient;
        }
    }

    protected CloseableScpClient createScpClient(ClientSession session) throws IOException {
        try {
            ScpClientCreator creator = this.getScpClientCreator();
            ScpClient client = creator.createScpClient(Objects.requireNonNull(session, "No client session"));
            return this.createScpClient(session, client);
        }
        catch (Exception e) {
            this.log.warn("createScpClient({}) failed ({}) to create proxy: {}", new Object[]{session, e.getClass().getSimpleName(), e.getMessage()});
            try {
                session.close();
            }
            catch (Exception t) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("createScpClient({}) failed ({}) to close session: {}", new Object[]{session, t.getClass().getSimpleName(), t.getMessage()});
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("createScpClient(" + session + ") session close failure details", (Throwable)t);
                }
                e.addSuppressed(t);
            }
            throw GenericUtils.toIOException((Throwable)e);
        }
    }

    protected CloseableScpClient createScpClient(ClientSession session, ScpClient client) throws IOException {
        ClassLoader loader = CloseableScpClient.class.getClassLoader();
        Class[] interfaces = new Class[]{CloseableScpClient.class};
        return (CloseableScpClient)Proxy.newProxyInstance(loader, interfaces, (proxy, method, args) -> {
            String name = method.getName();
            try {
                if (("close".equals(name) || "isOpen".equals(name)) && GenericUtils.isEmpty((Object[])args)) {
                    return method.invoke((Object)session, args);
                }
                return method.invoke((Object)client, args);
            }
            catch (Throwable t) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("invoke(CloseableScpClient#{}) failed ({}) to execute: {}", new Object[]{name, t.getClass().getSimpleName(), t.getMessage()});
                }
                throw t;
            }
        });
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

