/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build.model.clauses;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.stream.MapStream;
import aQute.lib.strings.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

public class HeaderClause
implements Cloneable,
Comparable<HeaderClause> {
    private static final String INTERNAL_LIST_SEPARATOR = ";";
    private static final String INTERNAL_LIST_SEPARATOR_NEWLINES = ";\\\n\t\t";
    protected String name;
    protected Attrs attribs;

    public HeaderClause(String name, Attrs attribs) {
        assert (name != null);
        this.name = name;
        this.attribs = attribs == null ? new Attrs() : attribs;
    }

    public HeaderClause(String v) {
        Parameters parameters = new Parameters(v);
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Invalid header clause (not exactly 1 element) " + v);
        }
        Map.Entry<String, Attrs> next = parameters.entrySet().iterator().next();
        this.name = next.getKey();
        this.attribs = next.getValue();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Attrs getAttribs() {
        return this.attribs;
    }

    public List<String> getListAttrib(String attrib) {
        String string = this.attribs.get(attrib);
        if (string == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result;
    }

    public void setListAttrib(String attrib, Collection<? extends String> value) {
        if (value == null || value.isEmpty()) {
            this.attribs.remove(attrib);
        } else {
            StringBuilder buffer = new StringBuilder();
            boolean first = true;
            for (String string : value) {
                if (!first) {
                    buffer.append(',');
                }
                buffer.append(string);
                first = false;
            }
            this.attribs.put(attrib, buffer.toString());
        }
    }

    public void formatTo(StringBuilder buffer) {
        this.formatTo(buffer, null, this.newlinesBetweenAttributes());
    }

    public void formatTo(StringBuilder buffer, boolean newlinesBetweenAttributes) {
        this.formatTo(buffer, null, newlinesBetweenAttributes);
    }

    public void formatTo(StringBuilder buffer, Comparator<Map.Entry<String, String>> sorter) {
        this.formatTo(buffer, sorter, this.newlinesBetweenAttributes());
    }

    public void formatTo(StringBuilder buffer, Comparator<Map.Entry<String, String>> sorter, boolean newlinesBetweenAttributes) {
        String separator;
        String string = separator = newlinesBetweenAttributes ? INTERNAL_LIST_SEPARATOR_NEWLINES : INTERNAL_LIST_SEPARATOR;
        if (this.name.indexOf(44) >= 0) {
            OSGiHeader.quote(buffer, this.name, '\'');
        } else {
            buffer.append(this.name);
        }
        MapStream<String, String> entries = MapStream.ofNullable(this.attribs);
        if (sorter != null) {
            entries = entries.sorted(sorter);
        }
        entries.filterValue(Strings::nonNullOrEmpty).forEachOrdered((name, value) -> {
            buffer.append(separator);
            int n = buffer.length();
            OSGiHeader.quote(buffer, name, '\'');
            n = buffer.length() - n;
            while (newlinesBetweenAttributes && n++ < 20) {
                buffer.append(' ');
            }
            buffer.append('=');
            OSGiHeader.quote(buffer, value, '\'');
        });
    }

    protected boolean newlinesBetweenAttributes() {
        return false;
    }

    public HeaderClause clone() {
        try {
            HeaderClause clone = (HeaderClause)super.clone();
            clone.name = this.name;
            clone.attribs = new Attrs(this.attribs);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(HeaderClause other) {
        return this.name.compareTo(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.attribs, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderClause other = (HeaderClause)obj;
        if (this.attribs == null ? other.attribs != null : !this.attribs.isEqual(other.attribs)) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.formatTo(b);
        return b.toString();
    }

    public static Parameters toParameters(List<? extends HeaderClause> l) {
        Parameters parameters = new Parameters();
        l.forEach(hc -> parameters.put(hc.name, hc.attribs));
        return parameters;
    }
}

