/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.remote;

import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.LinkString;
import org.apache.juneau.dto.html5.Div;
import org.apache.juneau.dto.html5.HtmlBuilder;
import org.apache.juneau.dto.html5.Table;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.remote.RrpcInterfaceMeta;
import org.apache.juneau.http.remote.RrpcInterfaceMethodMeta;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.http.response.UnsupportedMediaType;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.reflect.Mutaters;
import org.apache.juneau.rest.annotation.OpSwagger;
import org.apache.juneau.rest.annotation.RestGet;
import org.apache.juneau.rest.annotation.RestPost;
import org.apache.juneau.rest.servlet.BasicRestServlet;

public abstract class RrpcServlet
extends BasicRestServlet {
    private final Map<String, RrpcInterfaceMeta> serviceMap = new ConcurrentHashMap<String, RrpcInterfaceMeta>();

    protected abstract Map<Class<?>, Object> getServiceMap() throws Exception;

    @RestGet(path={"/"}, summary="List of available remote interfaces", description={"Shows a list of the interfaces registered with this remote interface servlet."})
    public List<LinkString> getInterfaces() throws Exception {
        LinkedList<LinkString> l = new LinkedList<LinkString>();
        for (Class<?> c : this.getServiceMap().keySet()) {
            l.add(new LinkString(c.getName(), "servlet:/{0}", new Object[]{StringUtils.urlEncode((String)c.getName())}));
        }
        return l;
    }

    @RestGet(path={"/{javaInterface}"}, summary="List of available methods on interface", description={"Shows a list of all the exposed methods on an interface."})
    @HtmlDocConfig(nav={"<h5>Interface:  $RP{javaInterface}</h5>"})
    public Collection<LinkString> listMethods(@Path(value="javaInterface") @Schema(description={"Java interface name"}) String javaInterface) throws Exception {
        ArrayList l = CollectionUtils.list((Object[])new LinkString[0]);
        for (String s : this.getMethods(javaInterface).keySet()) {
            l.add(new LinkString(s, "servlet:/{0}/{1}", new Object[]{StringUtils.urlEncode((String)javaInterface), StringUtils.urlEncode((String)s)}));
        }
        return l;
    }

    @RestGet(path={"/{javaInterface}/{javaMethod}"}, summary="Form entry for interface method call", description={"Shows a form entry page for executing a remote interface method."})
    @HtmlDocConfig(nav={"<h5>Interface:  $RP{javaInterface}</h5>", "<h5>Method:  $RP{javaMethod}</h5>"})
    public Div showEntryForm(@Path(value="javaInterface") @Schema(description={"Java interface name"}) String javaInterface, @Path(value="javaMethod") @Schema(description={"Java method name"}) String javaMethod) throws NotFound, Exception {
        RrpcInterfaceMethodMeta rmm = this.getMethods(javaInterface).get(javaMethod);
        if (rmm == null) {
            throw new NotFound("Method not found", new Object[0]);
        }
        Table t = HtmlBuilder.table();
        Type[] types = rmm.getJavaMethod().getGenericParameterTypes();
        if (types.length == 0) {
            t.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.td((Object[])new Object[]{"No arguments"}).colspan((Object)3).style("text-align:center")}));
        } else {
            t.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Index"}), HtmlBuilder.th((Object[])new Object[]{"Type"}), HtmlBuilder.th((Object[])new Object[]{"Value"})}));
            for (int i = 0; i < types.length; ++i) {
                String type = Mutaters.toString((Object)types[i]);
                t.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.td((Object[])new Object[]{i}), HtmlBuilder.td((Object[])new Object[]{type}), HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.input().name(String.valueOf(i)).type("text")})}));
            }
        }
        t.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.td().colspan((Object)3).style("text-align:right").children(new Object[]{types.length == 0 ? null : HtmlBuilder.button((String)"reset", (Object[])new Object[]{"Reset"}), HtmlBuilder.button((String)"button", (Object[])new Object[]{"Cancel"}).onclick("window.location.href='/'"), HtmlBuilder.button((String)"submit", (Object[])new Object[]{"Submit"})})}));
        return HtmlBuilder.div((Object[])new Object[]{HtmlBuilder.form().id("form").action("request:/").method("POST").children(new Object[]{t})});
    }

    @RestPost(path={"/{javaInterface}/{javaMethod}"}, summary="Invoke an interface method", description={"Invoke a Java method by passing in the arguments as an array of serialized objects.\nThe returned object is then serialized to the response."}, swagger=@OpSwagger(parameters={"{", "in: 'body',", "description: 'Serialized array of Java objects',", "schema: {", "type': 'array'", "},", "examples: {", "'application/json+lax': '[\\'foo\\', 123, true]'", "}", "}"}, responses={"200:{ description:'The return object serialized', schema:{type:'any'},example:{foo:123} }"}))
    @HtmlDocConfig(nav={"<h5>Interface:  $RP{javaInterface}</h5>", "<h5>Method:  $RP{javaMethod}</h5>"})
    public Object invoke(Reader r, ReaderParser p, @Header(value="Content-Type") ContentType contentType, @Path(value="javaInterface") @Schema(description={"Java interface name"}) String javaInterface, @Path(value="javaMethod") @Schema(description={"Java method name"}) String javaMethod) throws UnsupportedMediaType, NotFound, Exception {
        if (p == null) {
            throw new UnsupportedMediaType("Could not find parser for media type ''{0}''", new Object[]{contentType});
        }
        RrpcInterfaceMeta rim = this.getInterfaceClass(javaInterface);
        Object service = this.getServiceMap().get(rim.getJavaClass());
        if (service == null) {
            throw new NotFound("Service not found", new Object[0]);
        }
        RrpcInterfaceMethodMeta rmm = this.getMethods(javaInterface).get(javaMethod);
        if (rmm == null) {
            throw new NotFound("Method not found", new Object[0]);
        }
        Method m = rmm.getJavaMethod();
        Object[] params = p.parseArgs((Object)r, m.getGenericParameterTypes());
        return m.invoke(service, params);
    }

    private Map<String, RrpcInterfaceMethodMeta> getMethods(String javaInterface) throws Exception {
        return this.getInterfaceClass(javaInterface).getMethodsByPath();
    }

    private RrpcInterfaceMeta getInterfaceClass(String javaInterface) throws NotFound, Exception {
        RrpcInterfaceMeta rm = this.serviceMap.get(javaInterface);
        if (rm == null) {
            for (Class<?> c : this.getServiceMap().keySet()) {
                if (!c.getName().equals(javaInterface)) continue;
                rm = new RrpcInterfaceMeta(c, null);
                this.serviceMap.put(javaInterface, rm);
                return rm;
            }
            throw new NotFound("Interface class not found", new Object[0]);
        }
        return rm;
    }
}

