/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.jetty;

import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.collections.Args;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.microservice.Microservice;
import org.apache.juneau.microservice.MicroserviceListener;
import org.apache.juneau.microservice.console.ConsoleCommand;
import org.apache.juneau.microservice.jetty.BasicJettyMicroserviceListener;
import org.apache.juneau.microservice.jetty.BasicJettyServerFactory;
import org.apache.juneau.microservice.jetty.JettyMicroserviceListener;
import org.apache.juneau.microservice.jetty.JettyServerFactory;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.servlet.RestServlet;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.utils.ManifestFile;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class JettyMicroservice
extends Microservice {
    private static volatile JettyMicroservice INSTANCE;
    final Messages messages = Messages.of(JettyMicroservice.class);
    private final Builder builder;
    final JettyMicroserviceListener listener;
    private final JettyServerFactory factory;
    volatile Server server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInstance(JettyMicroservice m) {
        Class<JettyMicroservice> clazz = JettyMicroservice.class;
        synchronized (JettyMicroservice.class) {
            INSTANCE = m;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JettyMicroservice getInstance() {
        Class<JettyMicroservice> clazz = JettyMicroservice.class;
        synchronized (JettyMicroservice.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void main(String[] args) throws Exception {
        JettyMicroservice.create().args(args).build().start().startConsole().join();
    }

    public static Builder create() {
        return new Builder();
    }

    protected JettyMicroservice(Builder builder) throws ParseException, IOException {
        super((Microservice.Builder)builder);
        JettyMicroservice.setInstance(this);
        this.builder = builder.copy();
        this.listener = builder.listener != null ? builder.listener : new BasicJettyMicroserviceListener();
        this.factory = builder.factory != null ? builder.factory : new BasicJettyServerFactory();
    }

    public synchronized JettyMicroservice init() throws ParseException, IOException {
        super.init();
        return this;
    }

    public synchronized JettyMicroservice startConsole() throws Exception {
        super.startConsole();
        return this;
    }

    public synchronized JettyMicroservice stopConsole() throws Exception {
        super.stopConsole();
        return this;
    }

    public synchronized JettyMicroservice start() throws Exception {
        super.start();
        this.createServer();
        this.startServer();
        return this;
    }

    public JettyMicroservice join() throws Exception {
        this.server.join();
        return this;
    }

    public synchronized JettyMicroservice stop() throws Exception {
        final Logger logger = this.getLogger();
        final Messages mb2 = this.messages;
        Thread t = new Thread("JettyMicroserviceStop"){

            @Override
            public void run() {
                try {
                    if (JettyMicroservice.this.server == null || JettyMicroservice.this.server.isStopping() || JettyMicroservice.this.server.isStopped()) {
                        return;
                    }
                    JettyMicroservice.this.listener.onStopServer(JettyMicroservice.this);
                    JettyMicroservice.this.out(mb2, "StoppingServer", new Object[0]);
                    JettyMicroservice.this.server.stop();
                    JettyMicroservice.this.out(mb2, "ServerStopped", new Object[0]);
                    JettyMicroservice.this.listener.onPostStopServer(JettyMicroservice.this);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.stop();
        return this;
    }

    public int getPort() {
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            return ((ServerConnector)c).getPort();
        }
        throw new IllegalStateException("Could not locate ServerConnector in Jetty server.");
    }

    public String getContextPath() {
        for (Handler h : this.getServer().getHandlers()) {
            if (h instanceof HandlerCollection) {
                for (Handler h2 : ((HandlerCollection)h).getChildHandlers()) {
                    if (!(h2 instanceof ServletContextHandler)) continue;
                    return ((ServletContextHandler)h2).getContextPath();
                }
            }
            if (!(h instanceof ServletContextHandler)) continue;
            return ((ServletContextHandler)h).getContextPath();
        }
        throw new IllegalStateException("Could not locate ServletContextHandler in Jetty server.");
    }

    public String getProtocol() {
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            for (ConnectionFactory cf : ((ServerConnector)c).getConnectionFactories()) {
                if (!(cf instanceof SslConnectionFactory)) continue;
                return "https";
            }
        }
        return "http";
    }

    public String getHostName() {
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public URI getURI() {
        String cp = this.getContextPath();
        try {
            return new URI(this.getProtocol(), null, this.getHostName(), this.getPort(), "/".equals(cp) ? null : cp, null, null);
        }
        catch (URISyntaxException e) {
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
    }

    public Server createServer() throws ParseException, IOException, ExecutableException {
        this.listener.onCreateServer(this);
        Config cf = this.getConfig();
        ManifestFile mf = this.getManifest();
        VarResolver vr = this.getVarResolver();
        int[] ports = (int[])ObjectUtils.firstNonNull((Object[])new int[][]{this.builder.ports, cf.get("Jetty/port").as(int[].class).orElseGet(() -> JettyMicroservice.lambda$createServer$0((JsonMap)mf))});
        int availablePort = JettyMicroservice.findOpenPort(ports);
        if (System.getProperty("availablePort") == null) {
            System.setProperty("availablePort", String.valueOf(availablePort));
        }
        String jettyXml = this.builder.jettyXml;
        String jettyConfig = cf.get("Jetty/config").orElse(mf.getString("Jetty-Config", "jetty.xml"));
        boolean resolveVars = (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{this.builder.jettyXmlResolveVars, cf.get("Jetty/resolveVars").asBoolean().orElse(false)});
        if (jettyXml == null) {
            jettyXml = IOUtils.loadSystemResourceAsString((String)"jetty.xml", (String[])new String[]{".", "files"});
        }
        if (jettyXml == null) {
            throw new BasicRuntimeException("jetty.xml file ''{0}'' was not found on the file system or classpath.", new Object[]{jettyConfig});
        }
        if (resolveVars) {
            jettyXml = vr.resolve(jettyXml);
        }
        this.getLogger().info(jettyXml);
        try {
            this.server = this.factory.create(jettyXml);
        }
        catch (Exception e2) {
            throw new ExecutableException((Throwable)e2);
        }
        for (String s : cf.get("Jetty/servlets").asStringArray().orElse(new String[0])) {
            try {
                ClassInfo c = ClassInfo.of(Class.forName(s));
                if (!c.isChildOf(RestServlet.class)) {
                    throw new BasicRuntimeException("Invalid servlet specified in Jetty/servlets.  Must be a subclass of RestServlet: {0}", new Object[]{s});
                }
                RestServlet rs = (RestServlet)c.newInstance();
                this.addServlet((Servlet)rs, rs.getPath());
            }
            catch (ClassNotFoundException e1) {
                throw new ExecutableException((Throwable)e1);
            }
        }
        cf.get("Jetty/servletMap").asMap().orElse(JsonMap.EMPTY_MAP).forEach((k, v) -> {
            try {
                ClassInfo c = ClassInfo.of(Class.forName(v.toString()));
                if (!c.isChildOf(Servlet.class)) {
                    throw new BasicRuntimeException("Invalid servlet specified in Jetty/servletMap.  Must be a subclass of Servlet: {0}", new Object[]{v});
                }
                Servlet rs = (Servlet)c.newInstance();
                this.addServlet(rs, (String)k);
            }
            catch (ClassNotFoundException e1) {
                throw new ExecutableException((Throwable)e1);
            }
        });
        cf.get("Jetty/servletAttributes").asMap().orElse(JsonMap.EMPTY_MAP).forEach(this::addServletAttribute);
        this.builder.servlets.forEach((k, v) -> this.addServlet((Servlet)v, (String)k));
        this.builder.servletAttributes.forEach(this::addServletAttribute);
        if (System.getProperty("juneau.serverPort") == null) {
            System.setProperty("juneau.serverPort", String.valueOf(availablePort));
        }
        return this.server;
    }

    public void destroyServer() throws Exception {
        if (this.server != null) {
            this.server.destroy();
        }
        this.server = null;
    }

    public JettyMicroservice addServlet(Servlet servlet, String pathSpec) {
        ServletHolder sh = new ServletHolder(servlet);
        if (pathSpec != null && !((String)pathSpec).endsWith("/*")) {
            pathSpec = StringUtils.trimTrailingSlashes((String)pathSpec) + "/*";
        }
        this.getServletContextHandler().addServlet(sh, (String)pathSpec);
        return this;
    }

    protected ServletContextHandler getServletContextHandler() {
        for (Handler h : this.getServer().getHandlers()) {
            ServletContextHandler sch = JettyMicroservice.getServletContextHandler(h);
            if (sch == null) continue;
            return sch;
        }
        throw new IllegalStateException("Servlet context handler not found in jetty server.");
    }

    public JettyMicroservice addServletAttribute(String name, Object value) {
        this.getServer().setAttribute(name, value);
        return this;
    }

    public Server getServer() {
        return Objects.requireNonNull(this.server, "Server not found.  createServer() must be called first.");
    }

    protected int startServer() throws Exception {
        this.listener.onStartServer(this);
        this.server.start();
        this.out(this.messages, "ServerStarted", new Object[]{this.getPort()});
        this.listener.onPostStartServer(this);
        return this.getPort();
    }

    private static ServletContextHandler getServletContextHandler(Handler h) {
        if (h instanceof ServletContextHandler) {
            return (ServletContextHandler)h;
        }
        if (h instanceof HandlerCollection) {
            for (Handler h2 : ((HandlerCollection)h).getHandlers()) {
                ServletContextHandler sch = JettyMicroservice.getServletContextHandler(h2);
                if (sch == null) continue;
                return sch;
            }
        }
        return null;
    }

    private static int findOpenPort(int[] ports) {
        int[] nArray = ports;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int port = nArray[n2];
            if (port == 0) {
                port = new Random().nextInt(Short.MAX_VALUE - ports[0] + 1) + ports[0];
            }
            ServerSocket ss = new ServerSocket(port);
            try {
                n3 = port;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ss.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    ++n2;
                }
            }
            ss.close();
            return n3;
        }
        return 0;
    }

    private static /* synthetic */ int[] lambda$createServer$0(JsonMap mf) {
        return (int[])mf.getWithDefault("Jetty-Port", (Object)new int[]{8000}, int[].class);
    }

    public static class Builder
    extends Microservice.Builder {
        String jettyXml;
        int[] ports;
        Boolean jettyXmlResolveVars;
        Map<String, Servlet> servlets = CollectionUtils.map();
        Map<String, Object> servletAttributes = CollectionUtils.map();
        JettyMicroserviceListener listener;
        JettyServerFactory factory;

        protected Builder() {
        }

        protected Builder(Builder copyFrom) {
            super((Microservice.Builder)copyFrom);
            this.jettyXml = copyFrom.jettyXml;
            this.ports = copyFrom.ports;
            this.jettyXmlResolveVars = copyFrom.jettyXmlResolveVars;
            this.servlets = CollectionUtils.copyOf(copyFrom.servlets);
            this.servletAttributes = CollectionUtils.copyOf(copyFrom.servletAttributes);
            this.listener = copyFrom.listener;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder jettyXml(Object jettyXml, boolean resolveVars) throws IOException {
            if (jettyXml instanceof String) {
                this.jettyXml = IOUtils.read((File)this.resolveFile(jettyXml.toString()));
            } else if (jettyXml instanceof File) {
                this.jettyXml = IOUtils.read((File)((File)jettyXml));
            } else if (jettyXml instanceof InputStream) {
                this.jettyXml = IOUtils.read((InputStream)((InputStream)jettyXml));
            } else if (jettyXml instanceof Reader) {
                this.jettyXml = IOUtils.read((Reader)((Reader)jettyXml));
            } else {
                throw new BasicRuntimeException("Invalid object type passed to jettyXml(Object): {0}", new Object[]{ClassUtils.className((Object)jettyXml)});
            }
            this.jettyXmlResolveVars = resolveVars;
            return this;
        }

        public Builder ports(int ... ports) {
            this.ports = ports;
            return this;
        }

        public Builder servlet(Class<? extends RestServlet> c) throws ExecutableException {
            RestServlet rs;
            try {
                rs = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ExecutableException((Throwable)e);
            }
            return this.servlet((Servlet)rs, "/" + rs.getPath());
        }

        public Builder servlet(Class<? extends Servlet> c, String path) throws ExecutableException {
            try {
                return this.servlet(c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), path);
            }
            catch (Exception e) {
                throw new ExecutableException((Throwable)e);
            }
        }

        public Builder servlet(Servlet servlet, String path) {
            this.servlets.put(path, servlet);
            return this;
        }

        public Builder servlets(Map<String, Servlet> servlets) {
            if (servlets != null) {
                this.servlets.putAll(servlets);
            }
            return this;
        }

        public Builder servletAttribute(String name, Object value) {
            this.servletAttributes.put(name, value);
            return this;
        }

        public Builder servletAttribute(Map<String, Object> values) {
            if (values != null) {
                this.servletAttributes.putAll(values);
            }
            return this;
        }

        public Builder jettyServerFactory(JettyServerFactory value) {
            this.factory = value;
            return this;
        }

        public JettyMicroservice build() throws Exception {
            return new JettyMicroservice(this);
        }

        public Builder args(Args args) {
            super.args(args);
            return this;
        }

        public Builder args(String ... args) {
            super.args(args);
            return this;
        }

        public Builder manifest(Object manifest) throws IOException {
            super.manifest(manifest);
            return this;
        }

        public Builder logger(Logger logger) {
            super.logger(logger);
            return this;
        }

        public Builder config(Config config) {
            super.config(config);
            return this;
        }

        public Builder configName(String configName) {
            super.configName(configName);
            return this;
        }

        public Builder configStore(ConfigStore configStore) {
            super.configStore(configStore);
            return this;
        }

        public Builder consoleEnabled(boolean consoleEnabled) {
            super.consoleEnabled(consoleEnabled);
            return this;
        }

        public Builder consoleCommands(ConsoleCommand ... consoleCommands) {
            super.consoleCommands(consoleCommands);
            return this;
        }

        public Builder console(Scanner consoleReader, PrintWriter consoleWriter) {
            super.console(consoleReader, consoleWriter);
            return this;
        }

        public Builder vars(Class<? extends Var> ... vars) {
            super.vars((Class[])vars);
            return this;
        }

        public <T> Builder varBean(Class<T> c, T value) {
            super.varBean(c, value);
            return this;
        }

        public Builder workingDir(File path) {
            super.workingDir(path);
            return this;
        }

        public Builder workingDir(String path) {
            super.workingDir(path);
            return this;
        }

        public Builder listener(JettyMicroserviceListener listener) {
            super.listener((MicroserviceListener)listener);
            this.listener = listener;
            return this;
        }
    }
}

