/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.Map;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.StateMachineState;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;

public class StaticFileMapping {
    final Class<?> resourceClass;
    final String path;
    final String location;
    final Map<String, Object> responseHeaders;

    public StaticFileMapping(Class<?> resourceClass, String path, String location, Map<String, Object> responseHeaders) {
        this.resourceClass = resourceClass;
        this.path = StringUtils.trimSlashes(path);
        this.location = StringUtils.trimTrailingSlashes(location);
        this.responseHeaders = AMap.unmodifiable(responseHeaders);
    }

    public static AList<StaticFileMapping> parse(Class<?> resourceClass, String mapping) throws ParseException {
        if (StringUtils.isEmpty(mapping = StringUtils.trim(mapping))) {
            return new AList<StaticFileMapping>(0);
        }
        StateMachineState state = StateMachineState.S01;
        int mark = 0;
        String path = null;
        String location = null;
        AList<StaticFileMapping> l = AList.of();
        String s = mapping;
        int jsonDepth = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == StateMachineState.S01) {
                if (c != ':') continue;
                path = StringUtils.trim(s.substring(mark, i));
                mark = i + 1;
                state = StateMachineState.S02;
                continue;
            }
            if (state == StateMachineState.S02) {
                if (c == ':') {
                    location = StringUtils.trim(s.substring(mark, i));
                    mark = i + 1;
                    state = StateMachineState.S03;
                    continue;
                }
                if (c != ',') continue;
                location = StringUtils.trim(s.substring(mark, i));
                l.add(new StaticFileMapping(resourceClass, path, location, null));
                mark = i + 1;
                state = StateMachineState.S01;
                path = null;
                location = null;
                continue;
            }
            if (state == StateMachineState.S03) {
                if (c == '{') {
                    mark = i;
                    state = StateMachineState.S04;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                throw new ParseException("Invalid staticFiles mapping.  Expected '{' at beginning of headers.  mapping=[{0}]", mapping);
            }
            if (state == StateMachineState.S04) {
                if (c == '{') {
                    ++jsonDepth;
                    continue;
                }
                if (c != '}') continue;
                if (jsonDepth > 0) {
                    --jsonDepth;
                    continue;
                }
                String json = s.substring(mark, i + 1);
                l.add(new StaticFileMapping(resourceClass, path, location, OMap.ofJson(json)));
                state = StateMachineState.S05;
                path = null;
                location = null;
                continue;
            }
            if (state == StateMachineState.S05) {
                if (c == ',') {
                    state = StateMachineState.S06;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                throw new ParseException("Invalid staticFiles mapping.  Invalid text following headers.  mapping=[{0}]", mapping);
            }
            if (Character.isWhitespace(c)) continue;
            mark = i;
            state = StateMachineState.S01;
        }
        if (state == StateMachineState.S01) {
            throw new ParseException("Invalid staticFiles mapping.  Couldn''t find '':'' following path.  mapping=[{0}]", mapping);
        }
        if (state == StateMachineState.S02) {
            location = StringUtils.trim(s.substring(mark, s.length()));
            l.add(new StaticFileMapping(resourceClass, path, location, null));
        } else {
            if (state == StateMachineState.S03) {
                throw new ParseException("Invalid staticFiles mapping.  Found extra '':'' following location.  mapping=[{0}]", mapping);
            }
            if (state == StateMachineState.S04) {
                throw new ParseException("Invalid staticFiles mapping.  Malformed headers.  mapping=[{0}]", mapping);
            }
        }
        return l;
    }

    public String toString() {
        return SimpleJsonSerializer.DEFAULT_READABLE.toString(this.toMap());
    }

    public OMap toMap() {
        return new DefaultFilteringOMap().append("resourceClass", this.resourceClass).append("path", this.path).append("location", this.location).append("responseHeaders", this.responseHeaders);
    }
}

