/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentComparableAssertion;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters(returns="FluentBooleanAssertion<R>")
public class FluentBooleanAssertion<R>
extends FluentComparableAssertion<R> {
    private final Boolean value;

    public FluentBooleanAssertion(Boolean value, R returns) {
        this(null, value, returns);
    }

    public FluentBooleanAssertion(Assertion creator, Boolean value, R returns) {
        super(creator, value, returns);
        this.value = value;
    }

    public R isTrue() throws AssertionError {
        this.exists();
        if (!this.value.booleanValue()) {
            throw this.error("Value was false.", new Object[0]);
        }
        return this.returns();
    }

    public R isFalse() throws AssertionError {
        this.exists();
        if (this.value.booleanValue()) {
            throw this.error("Value was true.", new Object[0]);
        }
        return this.returns();
    }

    @Override
    public FluentBooleanAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentBooleanAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentBooleanAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

