/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SourceNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;

public abstract class TableDeviceSourceNode
extends SourceNode {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected String database;
    protected String tableName;
    protected List<ColumnHeader> columnHeaderList;
    protected TRegionReplicaSet schemaRegionReplicaSet;
    protected TDataNodeLocation senderLocation;

    protected TableDeviceSourceNode(PlanNodeId id, String database, String tableName, List<ColumnHeader> columnHeaderList, TDataNodeLocation senderLocation) {
        super(id);
        this.database = database;
        this.tableName = tableName;
        this.columnHeaderList = columnHeaderList;
        this.senderLocation = senderLocation;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnHeader> getColumnHeaderList() {
        return this.columnHeaderList;
    }

    public TDataNodeLocation getSenderLocation() {
        return this.senderLocation;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.columnHeaderList.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.schemaRegionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.schemaRegionReplicaSet = regionReplicaSet;
        if (!TableDeviceSchemaFetcher.getInstance().getAttributeGuard().isRegionFetched(regionReplicaSet.getRegionId().getId())) {
            this.senderLocation = new TDataNodeLocation(config.getDataNodeId(), null, new TEndPoint(config.getInternalAddress(), config.getInternalPort()), null, null, null);
        }
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.columnHeaderList.stream().map(columnHeader -> new Symbol(columnHeader.getColumnName())).collect(Collectors.toList());
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TableDeviceSourceNode that = (TableDeviceSourceNode)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.schemaRegionReplicaSet, that.schemaRegionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.database, this.tableName, this.schemaRegionReplicaSet);
    }
}

