/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ReservationId
implements Comparable<ReservationId> {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String reserveIdStrPrefix = "reservation_";
    protected long clusterTimestamp;
    protected long id;
    static final ThreadLocal<NumberFormat> reservIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ReservationId newInstance(long clusterTimestamp, long id) {
        ReservationId reservationId = Records.newRecord(ReservationId.class);
        reservationId.setClusterTimestamp(clusterTimestamp);
        reservationId.setId(id);
        reservationId.build();
        return reservationId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setId(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getClusterTimestamp();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setClusterTimestamp(long var1);

    protected abstract void build();

    @Override
    public int compareTo(ReservationId other) {
        if (this.getClusterTimestamp() - other.getClusterTimestamp() == 0L) {
            return this.getId() > this.getId() ? 1 : (this.getId() < this.getId() ? -1 : 0);
        }
        return this.getClusterTimestamp() > other.getClusterTimestamp() ? 1 : (this.getClusterTimestamp() < other.getClusterTimestamp() ? -1 : 0);
    }

    public String toString() {
        return reserveIdStrPrefix + this.getClusterTimestamp() + "_" + reservIdFormat.get().format(this.getId());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ReservationId parseReservationId(String reservationId) throws IOException {
        if (reservationId == null) {
            return null;
        }
        if (!reservationId.startsWith(reserveIdStrPrefix)) {
            throw new IOException("The specified reservation id is invalid: " + reservationId);
        }
        String[] resFields = reservationId.split("_");
        if (resFields.length != 3) {
            throw new IOException("The specified reservation id is not parseable: " + reservationId);
        }
        return ReservationId.newInstance(Long.parseLong(resFields[1]), Long.parseLong(resFields[2]));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.getClusterTimestamp() ^ this.getClusterTimestamp() >>> 32);
        result = 31 * result + (int)(this.getId() ^ this.getId() >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReservationId other = (ReservationId)obj;
        if (this.getClusterTimestamp() != other.getClusterTimestamp()) {
            return false;
        }
        return this.getId() == other.getId();
    }
}

