/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;

public class ReplicaOutputStreams
implements Closeable {
    private final OutputStream dataOut;
    private final OutputStream checksumOut;
    private final DataChecksum checksum;
    private final boolean isTransientStorage;

    public ReplicaOutputStreams(OutputStream dataOut, OutputStream checksumOut, DataChecksum checksum, boolean isTransientStorage) {
        this.dataOut = dataOut;
        this.checksumOut = checksumOut;
        this.checksum = checksum;
        this.isTransientStorage = isTransientStorage;
    }

    public OutputStream getDataOut() {
        return this.dataOut;
    }

    public OutputStream getChecksumOut() {
        return this.checksumOut;
    }

    public DataChecksum getChecksum() {
        return this.checksum;
    }

    public boolean isTransientStorage() {
        return this.isTransientStorage;
    }

    @Override
    public void close() {
        IOUtils.closeStream((Closeable)this.dataOut);
        IOUtils.closeStream((Closeable)this.checksumOut);
    }

    public void syncDataOut() throws IOException {
        if (this.dataOut instanceof FileOutputStream) {
            ((FileOutputStream)this.dataOut).getChannel().force(true);
        }
    }

    public void syncChecksumOut() throws IOException {
        if (this.checksumOut instanceof FileOutputStream) {
            ((FileOutputStream)this.checksumOut).getChannel().force(true);
        }
    }
}

