/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.util.LinuxResourceCalculatorPlugin;
import org.apache.hadoop.yarn.util.WindowsResourceCalculatorPlugin;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MAPREDUCE"})
@InterfaceStability.Unstable
public abstract class ResourceCalculatorPlugin
extends Configured {
    public abstract long getVirtualMemorySize();

    public abstract long getPhysicalMemorySize();

    public abstract long getAvailableVirtualMemorySize();

    public abstract long getAvailablePhysicalMemorySize();

    public abstract int getNumProcessors();

    public abstract long getCpuFrequency();

    public abstract long getCumulativeCpuTime();

    public abstract float getCpuUsage();

    public static ResourceCalculatorPlugin getResourceCalculatorPlugin(Class<? extends ResourceCalculatorPlugin> clazz, Configuration conf) {
        if (clazz != null) {
            return (ResourceCalculatorPlugin)((Object)ReflectionUtils.newInstance(clazz, (Configuration)conf));
        }
        try {
            if (Shell.LINUX) {
                return new LinuxResourceCalculatorPlugin();
            }
            if (Shell.WINDOWS) {
                return new WindowsResourceCalculatorPlugin();
            }
        }
        catch (SecurityException se) {
            return null;
        }
        return null;
    }
}

