/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LocalConfigurationProvider
extends ConfigurationProvider {
    public InputStream getConfigurationInputStream(Configuration bootstrapConf, String name) throws IOException, YarnException {
        if (name == null || name.isEmpty()) {
            throw new YarnException("Illegal argument! The parameter should not be null or empty");
        }
        if (YarnConfiguration.RM_CONFIGURATION_FILES.contains(name)) {
            return bootstrapConf.getConfResourceAsInputStream(name);
        }
        return new FileInputStream(name);
    }

    public void initInternal(Configuration bootstrapConf) throws Exception {
    }

    public void closeInternal() throws Exception {
    }
}

